// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicebindings;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.Map;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the Create Service Binding
 */
public final class CreateServiceBindingRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the applicationId
     */
    private final String applicationId;
    
    /**
     * Key/value pairs of all arbitrary parameters to pass along to the service broker
     */
    private final Map<String, Object> parameters;
    
    /**
     * The service instance id
     *
     * @param serviceInstanceId the service instance id
     */
    private final String serviceInstanceId;

    CreateServiceBindingRequest(String applicationId, String serviceInstanceId, Map<String, Object> parameters) {
        this.applicationId = applicationId;
        this.serviceInstanceId = serviceInstanceId;
        this.parameters = parameters;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateServiceBindingRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceInstanceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> parameters$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> parameters$value;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateServiceBindingRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBindingRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBindingRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBindingRequestBuilder parameter(final String parameterKey, final Object parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new java.util.ArrayList<String>();
                this.parameters$value = new java.util.ArrayList<Object>();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBindingRequestBuilder parameters(final java.util.Map<? extends String, ? extends Object> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new java.util.ArrayList<String>();
                this.parameters$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBindingRequest build() {
            java.util.Map<String, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
            case 0: 
                parameters = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                parameters = java.util.Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                break;
            
            default: 
                parameters = new java.util.LinkedHashMap<String, Object>(this.parameters$key.size() < 1073741824 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.parameters$key.size(); $i++) parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                parameters = java.util.Collections.unmodifiableMap(parameters);
            
            }
            return new CreateServiceBindingRequest(applicationId, serviceInstanceId, parameters);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateServiceBindingRequest.CreateServiceBindingRequestBuilder(applicationId=" + this.applicationId + ", serviceInstanceId=" + this.serviceInstanceId + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateServiceBindingRequestBuilder builder() {
        return new CreateServiceBindingRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreateServiceBindingRequest)) return false;
        final CreateServiceBindingRequest other = (CreateServiceBindingRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$parameters = this.getParameters();
        final java.lang.Object other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) return false;
        final java.lang.Object this$serviceInstanceId = this.getServiceInstanceId();
        final java.lang.Object other$serviceInstanceId = other.getServiceInstanceId();
        if (this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $parameters = this.getParameters();
        result = result * PRIME + ($parameters == null ? 43 : $parameters.hashCode());
        final java.lang.Object $serviceInstanceId = this.getServiceInstanceId();
        result = result * PRIME + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreateServiceBindingRequest(applicationId=" + this.getApplicationId() + ", parameters=" + this.getParameters() + ", serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    /**
     * The application id
     *
     * @return the applicationId
     */
    @JsonProperty("app_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * Key/value pairs of all arbitrary parameters to pass along to the service broker
     *
     * @return the arbitrary parameters to pass along to the service broker
     */
    @JsonProperty("parameters")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    /**
     * The service instance id
     *
     * @return the service instance id
     */
    @JsonProperty("service_instance_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }
}