// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicebindings;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service bindings operation
 */
public final class ListServiceBindingsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The application ids
     *
     * @param applicationIds the application ids
     */
    private final List<String> applicationIds;
    
    /**
     * The service instance ids
     *
     * @param serviceInstanceIds the service instance ids
     */
    private final List<String> serviceInstanceIds;

    ListServiceBindingsRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServiceBindingsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> applicationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceInstanceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServiceBindingsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequestBuilder applicationId(final String applicationId) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.add(applicationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequestBuilder applicationIds(final java.util.Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequestBuilder serviceInstanceIds(final java.util.Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBindingsRequest build() {
            java.util.List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
            case 0: 
                applicationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                applicationIds = java.util.Collections.singletonList(this.applicationIds.get(0));
                break;
            
            default: 
                applicationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.applicationIds));
            
            }
            java.util.List<String> serviceInstanceIds;
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
            case 0: 
                serviceInstanceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceInstanceIds = java.util.Collections.singletonList(this.serviceInstanceIds.get(0));
                break;
            
            default: 
                serviceInstanceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceInstanceIds));
            
            }
            return new ListServiceBindingsRequest(orderDirection, page, resultsPerPage, applicationIds, serviceInstanceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServiceBindingsRequest.ListServiceBindingsRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServiceBindingsRequestBuilder builder() {
        return new ListServiceBindingsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServiceBindingsRequest)) return false;
        final ListServiceBindingsRequest other = (ListServiceBindingsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationIds = this.getApplicationIds();
        final java.lang.Object other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !this$applicationIds.equals(other$applicationIds)) return false;
        final java.lang.Object this$serviceInstanceIds = this.getServiceInstanceIds();
        final java.lang.Object other$serviceInstanceIds = other.getServiceInstanceIds();
        if (this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !this$serviceInstanceIds.equals(other$serviceInstanceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServiceBindingsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationIds = this.getApplicationIds();
        result = result * PRIME + ($applicationIds == null ? 43 : $applicationIds.hashCode());
        final java.lang.Object $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * PRIME + ($serviceInstanceIds == null ? 43 : $serviceInstanceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServiceBindingsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    /**
     * The application ids
     *
     * @return the application ids
     */
    @InFilterParameter("app_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    /**
     * The service instance ids
     *
     * @return the service instance ids
     */
    @InFilterParameter("service_instance_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }
}