// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Create Service Broker
 */
public final class CreateServiceBrokerRequest implements Validatable {
    
    /**
     * The password with which to authenticate against the service broker.
     *
     * @param authPassword the password for authentication
     */
    private final String authenticationPassword;
    
    /**
     * The username with which to authenticate against the service broker.
     *
     * @param authUsername the username for authentication
     */
    private final String authenticationUsername;
    
    /**
     * The url of the service broker.
     *
     * @param brokerUrl the broker url
     */
    private final String brokerUrl;
    
    /**
     * The name of the service broker.
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * (experimental) Guid of a space the broker is scoped to. Space developers are able to create service brokers scoped to a space.
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    CreateServiceBrokerRequest(String authenticationPassword, String authenticationUsername, String brokerUrl, String name, String spaceId) {
        this.authenticationPassword = authenticationPassword;
        this.authenticationUsername = authenticationUsername;
        this.brokerUrl = brokerUrl;
        this.name = name;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.authenticationUsername == null) {
            builder.message("authentication username must be specified");
        }
        if (this.authenticationPassword == null) {
            builder.message("authentication password must be specified");
        }
        if (this.brokerUrl == null) {
            builder.message("broker url must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateServiceBrokerRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String authenticationPassword;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String authenticationUsername;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String brokerUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateServiceBrokerRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBrokerRequestBuilder authenticationPassword(final String authenticationPassword) {
            this.authenticationPassword = authenticationPassword;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBrokerRequestBuilder authenticationUsername(final String authenticationUsername) {
            this.authenticationUsername = authenticationUsername;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBrokerRequestBuilder brokerUrl(final String brokerUrl) {
            this.brokerUrl = brokerUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBrokerRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBrokerRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceBrokerRequest build() {
            return new CreateServiceBrokerRequest(authenticationPassword, authenticationUsername, brokerUrl, name, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateServiceBrokerRequest.CreateServiceBrokerRequestBuilder(authenticationPassword=" + this.authenticationPassword + ", authenticationUsername=" + this.authenticationUsername + ", brokerUrl=" + this.brokerUrl + ", name=" + this.name + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateServiceBrokerRequestBuilder builder() {
        return new CreateServiceBrokerRequestBuilder();
    }

    /**
     * The password with which to authenticate against the service broker.
     *
     * @return the password for authentication
     */
    @JsonProperty("auth_password")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    /**
     * The username with which to authenticate against the service broker.
     *
     * @return the username for authentication
     */
    @JsonProperty("auth_username")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    /**
     * The url of the service broker.
     *
     * @return the broker url
     */
    @JsonProperty("broker_url")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    /**
     * The name of the service broker.
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * (experimental) Guid of a space the broker is scoped to. Space developers are able to create service brokers scoped to a space.
     *
     * @return the space id
     */
    @JsonProperty("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}