// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Get Service Broker operation
 */
public final class GetServiceBrokerRequest implements Validatable {
    
    /**
     * The service broker id
     *
     * @param serviceBrokerId the service broker id
     */
    private final String serviceBrokerId;

    GetServiceBrokerRequest(String serviceBrokerId) {
        this.serviceBrokerId = serviceBrokerId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceBrokerId == null) {
            builder.message("service broker id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetServiceBrokerRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceBrokerId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetServiceBrokerRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServiceBrokerRequestBuilder serviceBrokerId(final String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServiceBrokerRequest build() {
            return new GetServiceBrokerRequest(serviceBrokerId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetServiceBrokerRequest.GetServiceBrokerRequestBuilder(serviceBrokerId=" + this.serviceBrokerId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetServiceBrokerRequestBuilder builder() {
        return new GetServiceBrokerRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetServiceBrokerRequest)) return false;
        final GetServiceBrokerRequest other = (GetServiceBrokerRequest)o;
        final java.lang.Object this$serviceBrokerId = this.getServiceBrokerId();
        final java.lang.Object other$serviceBrokerId = other.getServiceBrokerId();
        if (this$serviceBrokerId == null ? other$serviceBrokerId != null : !this$serviceBrokerId.equals(other$serviceBrokerId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $serviceBrokerId = this.getServiceBrokerId();
        result = result * PRIME + ($serviceBrokerId == null ? 43 : $serviceBrokerId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetServiceBrokerRequest(serviceBrokerId=" + this.getServiceBrokerId() + ")";
    }

    /**
     * The service broker id
     *
     * @return the service broker id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }
}