// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service brokers operation
 */
public final class ListServiceBrokersRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The space ids
     *
     * @param spaceIds the space ids
     */
    private final List<String> spaceIds;

    ListServiceBrokersRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, List<String> spaceIds) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServiceBrokersRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> spaceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServiceBrokersRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequestBuilder spaceId(final String spaceId) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.add(spaceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequestBuilder spaceIds(final java.util.Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceBrokersRequest build() {
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            java.util.List<String> spaceIds;
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
            case 0: 
                spaceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                spaceIds = java.util.Collections.singletonList(this.spaceIds.get(0));
                break;
            
            default: 
                spaceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.spaceIds));
            
            }
            return new ListServiceBrokersRequest(orderDirection, page, resultsPerPage, names, spaceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServiceBrokersRequest.ListServiceBrokersRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", spaceIds=" + this.spaceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServiceBrokersRequestBuilder builder() {
        return new ListServiceBrokersRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServiceBrokersRequest)) return false;
        final ListServiceBrokersRequest other = (ListServiceBrokersRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$spaceIds = this.getSpaceIds();
        final java.lang.Object other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !this$spaceIds.equals(other$spaceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServiceBrokersRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $spaceIds = this.getSpaceIds();
        result = result * PRIME + ($spaceIds == null ? 43 : $spaceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServiceBrokersRequest(super=" + super.toString() + ", names=" + this.getNames() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    /**
     * The names
     *
     * @return the names
     */
    @InFilterParameter("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The space ids
     *
     * @return the space ids
     */
    @InFilterParameter("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }
}