// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The entity response payload for Service Broker
 */
public final class ServiceBrokerEntity {
    
    /**
     * The authentication username
     *
     * @param authUsername the authentication username
     */
    private final String authenticationUsername;
    
    /**
     * The url of the service broker.
     *
     * @param brokerUrl the broker url
     */
    private final String brokerUrl;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    ServiceBrokerEntity(@JsonProperty("auth_username") String authenticationUsername, @JsonProperty("broker_url") String brokerUrl, @JsonProperty("name") String name, @JsonProperty("space_guid") String spaceId) {
        this.authenticationUsername = authenticationUsername;
        this.brokerUrl = brokerUrl;
        this.name = name;
        this.spaceId = spaceId;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ServiceBrokerEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String authenticationUsername;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String brokerUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ServiceBrokerEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceBrokerEntityBuilder authenticationUsername(final String authenticationUsername) {
            this.authenticationUsername = authenticationUsername;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceBrokerEntityBuilder brokerUrl(final String brokerUrl) {
            this.brokerUrl = brokerUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceBrokerEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceBrokerEntityBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceBrokerEntity build() {
            return new ServiceBrokerEntity(authenticationUsername, brokerUrl, name, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ServiceBrokerEntity.ServiceBrokerEntityBuilder(authenticationUsername=" + this.authenticationUsername + ", brokerUrl=" + this.brokerUrl + ", name=" + this.name + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ServiceBrokerEntityBuilder builder() {
        return new ServiceBrokerEntityBuilder();
    }

    /**
     * The authentication username
     *
     * @return the authentication username
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    /**
     * The url of the service broker.
     *
     * @return the broker url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServiceBrokerEntity)) return false;
        final ServiceBrokerEntity other = (ServiceBrokerEntity)o;
        final java.lang.Object this$authenticationUsername = this.getAuthenticationUsername();
        final java.lang.Object other$authenticationUsername = other.getAuthenticationUsername();
        if (this$authenticationUsername == null ? other$authenticationUsername != null : !this$authenticationUsername.equals(other$authenticationUsername)) return false;
        final java.lang.Object this$brokerUrl = this.getBrokerUrl();
        final java.lang.Object other$brokerUrl = other.getBrokerUrl();
        if (this$brokerUrl == null ? other$brokerUrl != null : !this$brokerUrl.equals(other$brokerUrl)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $authenticationUsername = this.getAuthenticationUsername();
        result = result * PRIME + ($authenticationUsername == null ? 43 : $authenticationUsername.hashCode());
        final java.lang.Object $brokerUrl = this.getBrokerUrl();
        result = result * PRIME + ($brokerUrl == null ? 43 : $brokerUrl.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ServiceBrokerEntity(authenticationUsername=" + this.getAuthenticationUsername() + ", brokerUrl=" + this.getBrokerUrl() + ", name=" + this.getName() + ", spaceId=" + this.getSpaceId() + ")";
    }
}