// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicebrokers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateServiceBrokerRequest implements Validatable {
    
    /**
     * The password with which to authenticate against the service broker.
     *
     * @param authPassword the password for authentication
     */
    private final String authenticationPassword;
    
    /**
     * The username with which to authenticate against the service broker.
     *
     * @param authUsername the username for authentication
     */
    private final String authenticationUsername;
    
    /**
     * The url of the service broker.
     *
     * @param brokerUrl the broker url
     */
    private final String brokerUrl;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The service broker id
     *
     * @param serviceBrokerId the service broker id
     */
    private final String serviceBrokerId;

    UpdateServiceBrokerRequest(String authenticationPassword, String authenticationUsername, String brokerUrl, String name, String serviceBrokerId) {
        this.authenticationPassword = authenticationPassword;
        this.authenticationUsername = authenticationUsername;
        this.brokerUrl = brokerUrl;
        this.serviceBrokerId = serviceBrokerId;
        this.name = name;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceBrokerId == null) {
            builder.message("service broker id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateServiceBrokerRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String authenticationPassword;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String authenticationUsername;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String brokerUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceBrokerId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateServiceBrokerRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServiceBrokerRequestBuilder authenticationPassword(final String authenticationPassword) {
            this.authenticationPassword = authenticationPassword;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServiceBrokerRequestBuilder authenticationUsername(final String authenticationUsername) {
            this.authenticationUsername = authenticationUsername;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServiceBrokerRequestBuilder brokerUrl(final String brokerUrl) {
            this.brokerUrl = brokerUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServiceBrokerRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServiceBrokerRequestBuilder serviceBrokerId(final String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServiceBrokerRequest build() {
            return new UpdateServiceBrokerRequest(authenticationPassword, authenticationUsername, brokerUrl, name, serviceBrokerId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateServiceBrokerRequest.UpdateServiceBrokerRequestBuilder(authenticationPassword=" + this.authenticationPassword + ", authenticationUsername=" + this.authenticationUsername + ", brokerUrl=" + this.brokerUrl + ", name=" + this.name + ", serviceBrokerId=" + this.serviceBrokerId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateServiceBrokerRequestBuilder builder() {
        return new UpdateServiceBrokerRequestBuilder();
    }

    /**
     * The password with which to authenticate against the service broker.
     *
     * @return the password for authentication
     */
    @JsonProperty("auth_password")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    /**
     * The username with which to authenticate against the service broker.
     *
     * @return the username for authentication
     */
    @JsonProperty("auth_username")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuthenticationUsername() {
        return this.authenticationUsername;
    }

    /**
     * The url of the service broker.
     *
     * @return the broker url
     */
    @JsonProperty("broker_url")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The service broker id
     *
     * @return the service broker id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }
}