// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.List;
import java.util.Map;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the Create Service Instance
 */
public final class CreateServiceInstanceRequest implements Validatable {
    
    /**
     * The accept incomplete flag
     *
     * @param acceptsIncomplete Set to `true` if the client allows asynchronous provisioning. The cloud controller may respond before the service is ready for use.
     */
    private final boolean acceptsIncomplete;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * Key/value pairs of all arbitrary parameters to pass along to the service broker
     */
    private final Map<String, Object> parameters;
    
    /**
     * The service plan id
     *
     * @param servicePlanId the service plan id
     */
    private final String servicePlanId;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * A list of tags for the service instance
     */
    private final List<String> tags;

    CreateServiceInstanceRequest(boolean acceptsIncomplete, String name, Map<String, Object> parameters, String servicePlanId, String spaceId, List<String> tags) {
        this.acceptsIncomplete = acceptsIncomplete;
        this.name = name;
        this.parameters = parameters;
        this.servicePlanId = servicePlanId;
        this.spaceId = spaceId;
        this.tags = tags;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateServiceInstanceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private boolean acceptsIncomplete;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> parameters$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> parameters$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> tags;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateServiceInstanceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder acceptsIncomplete(final boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder parameter(final String parameterKey, final Object parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new java.util.ArrayList<String>();
                this.parameters$value = new java.util.ArrayList<Object>();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder parameters(final java.util.Map<? extends String, ? extends Object> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new java.util.ArrayList<String>();
                this.parameters$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder servicePlanId(final String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder tag(final String tag) {
            if (this.tags == null) this.tags = new java.util.ArrayList<String>();
            this.tags.add(tag);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequestBuilder tags(final java.util.Collection<? extends String> tags) {
            if (this.tags == null) this.tags = new java.util.ArrayList<String>();
            this.tags.addAll(tags);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceInstanceRequest build() {
            java.util.Map<String, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
            case 0: 
                parameters = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                parameters = java.util.Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                break;
            
            default: 
                parameters = new java.util.LinkedHashMap<String, Object>(this.parameters$key.size() < 1073741824 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.parameters$key.size(); $i++) parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                parameters = java.util.Collections.unmodifiableMap(parameters);
            
            }
            java.util.List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
            case 0: 
                tags = java.util.Collections.emptyList();
                break;
            
            case 1: 
                tags = java.util.Collections.singletonList(this.tags.get(0));
                break;
            
            default: 
                tags = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.tags));
            
            }
            return new CreateServiceInstanceRequest(acceptsIncomplete, name, parameters, servicePlanId, spaceId, tags);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateServiceInstanceRequest.CreateServiceInstanceRequestBuilder(acceptsIncomplete=" + this.acceptsIncomplete + ", name=" + this.name + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ", servicePlanId=" + this.servicePlanId + ", spaceId=" + this.spaceId + ", tags=" + this.tags + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateServiceInstanceRequestBuilder builder() {
        return new CreateServiceInstanceRequestBuilder();
    }

    /**
     * The accept incomplete flag
     *
     * @return the accept incomplete flag
     */
    @QueryParameter("accepts_incomplete")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean isAcceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * Key/value pairs of all arbitrary parameters to pass along to the service broker
     *
     * @return the arbitrary parameters to pass along to the service broker
     */
    @JsonProperty("parameters")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    /**
     * The service plan id
     *
     * @return the service plan id
     */
    @JsonProperty("service_plan_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonProperty("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * A list of tags for the service instance
     *
     * @return the list of tags for the service instance
     */
    @JsonProperty("tags")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getTags() {
        return this.tags;
    }
}