// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Delete Service Instance operation.
 */
public final class DeleteServiceInstanceRequest implements Validatable {
    
    /**
     * The accept incomplete flag
     *
     * @param acceptsIncomplete (experimental) Set to `true` if the client allows asynchronous provisioning. The cloud controller may respond before the service is deleted.
     */
    private final Boolean acceptsIncomplete;
    
    /**
     * The purge flag
     *
     * @param purge (experimental) Recursively remove a service instance and child objects from Cloud Foundry database without making requests to a service broker .
     */
    private final Boolean purge;
    
    /**
     * The service instance id
     *
     * @param serviceInstanceId the service instance id
     */
    private final String serviceInstanceId;

    DeleteServiceInstanceRequest(Boolean acceptsIncomplete, Boolean purge, String serviceInstanceId) {
        this.acceptsIncomplete = acceptsIncomplete;
        this.purge = purge;
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeleteServiceInstanceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean acceptsIncomplete;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean purge;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceInstanceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeleteServiceInstanceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceInstanceRequestBuilder acceptsIncomplete(final Boolean acceptsIncomplete) {
            this.acceptsIncomplete = acceptsIncomplete;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceInstanceRequestBuilder purge(final Boolean purge) {
            this.purge = purge;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceInstanceRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceInstanceRequest build() {
            return new DeleteServiceInstanceRequest(acceptsIncomplete, purge, serviceInstanceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeleteServiceInstanceRequest.DeleteServiceInstanceRequestBuilder(acceptsIncomplete=" + this.acceptsIncomplete + ", purge=" + this.purge + ", serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeleteServiceInstanceRequestBuilder builder() {
        return new DeleteServiceInstanceRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DeleteServiceInstanceRequest)) return false;
        final DeleteServiceInstanceRequest other = (DeleteServiceInstanceRequest)o;
        final java.lang.Object this$acceptsIncomplete = this.getAcceptsIncomplete();
        final java.lang.Object other$acceptsIncomplete = other.getAcceptsIncomplete();
        if (this$acceptsIncomplete == null ? other$acceptsIncomplete != null : !this$acceptsIncomplete.equals(other$acceptsIncomplete)) return false;
        final java.lang.Object this$purge = this.getPurge();
        final java.lang.Object other$purge = other.getPurge();
        if (this$purge == null ? other$purge != null : !this$purge.equals(other$purge)) return false;
        final java.lang.Object this$serviceInstanceId = this.getServiceInstanceId();
        final java.lang.Object other$serviceInstanceId = other.getServiceInstanceId();
        if (this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $acceptsIncomplete = this.getAcceptsIncomplete();
        result = result * PRIME + ($acceptsIncomplete == null ? 43 : $acceptsIncomplete.hashCode());
        final java.lang.Object $purge = this.getPurge();
        result = result * PRIME + ($purge == null ? 43 : $purge.hashCode());
        final java.lang.Object $serviceInstanceId = this.getServiceInstanceId();
        result = result * PRIME + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "DeleteServiceInstanceRequest(acceptsIncomplete=" + this.getAcceptsIncomplete() + ", purge=" + this.getPurge() + ", serviceInstanceId=" + this.getServiceInstanceId() + ")";
    }

    /**
     * The accept incomplete flag
     *
     * @return the accept incomplete flag
     */
    @QueryParameter("accepts_incomplete")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getAcceptsIncomplete() {
        return this.acceptsIncomplete;
    }

    /**
     * The purge flag
     *
     * @return the purge flag
     */
    @QueryParameter("purge")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getPurge() {
        return this.purge;
    }

    /**
     * The service instance id
     *
     * @return the service instance id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }
}