// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A service instance
 */
public final class ServiceInstance {
    
    /**
     * The bound application count
     *
     * @param boundApplicationCount the bound application count
     */
    private final Integer boundApplicationCount;
    
    /**
     * The dashboard url
     *
     * @param dashboardUrl the dashboard url
     */
    private final String dashboardUrl;
    
    /**
     * The id
     *
     * @param id the id
     */
    private final String id;
    
    /**
     * The last operation
     *
     * @param lastOperation the last operation
     */
    private final LastOperation lastOperation;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The service plan
     *
     * @param servicePlan the service plan
     */
    private final Plan servicePlan;

    ServiceInstance(@JsonProperty("bound_app_count") Integer boundApplicationCount, @JsonProperty("dashboard_url") String dashboardUrl, @JsonProperty("guid") String id, @JsonProperty("last_operation") LastOperation lastOperation, @JsonProperty("name") String name, @JsonProperty("service_plan") Plan servicePlan) {
        this.boundApplicationCount = boundApplicationCount;
        this.dashboardUrl = dashboardUrl;
        this.id = id;
        this.lastOperation = lastOperation;
        this.name = name;
        this.servicePlan = servicePlan;
    }

    /**
     * A service plan
     */
    public static final class Plan {
        /**
         * The id
         *
         * @param id the id
         * @return the id
         */
        private final String id;
        /**
         * The name
         *
         * @param name the name
         * @return the name
         */
        private final String name;
        /**
         * The service
         *
         * @param service the service
         * @return the service
         */
        private final Service service;

        Plan(@JsonProperty("guid") String id, @JsonProperty("name") String name, @JsonProperty("service") Service service) {
            this.id = id;
            this.name = name;
            this.service = service;
        }

        public static final class Service {
            /**
             * The id
             *
             * @param id the id
             * @return the id
             */
            private final String id;
            /**
             * The label
             *
             * @param label the label
             * @return the label
             */
            private final String label;
            /**
             * The provider
             *
             * @param provider the provider
             * @return the provider
             */
            private final String provider;
            /**
             * The version
             *
             * @param version the version
             * @return the version
             */
            private final String version;

            Service(@JsonProperty("guid") String id, @JsonProperty("label") String label, @JsonProperty("provider") String provider, @JsonProperty("version") String version) {
                this.id = id;
                this.label = label;
                this.provider = provider;
                this.version = version;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public static class ServiceBuilder {
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private String id;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private String label;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private String provider;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private String version;

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                ServiceBuilder() {
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public ServiceBuilder id(final String id) {
                    this.id = id;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public ServiceBuilder label(final String label) {
                    this.label = label;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public ServiceBuilder provider(final String provider) {
                    this.provider = provider;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public ServiceBuilder version(final String version) {
                    this.version = version;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public Service build() {
                    return new Service(id, label, provider, version);
                }

                @java.lang.Override
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public java.lang.String toString() {
                    return "ServiceInstance.Plan.Service.ServiceBuilder(id=" + this.id + ", label=" + this.label + ", provider=" + this.provider + ", version=" + this.version + ")";
                }
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public static ServiceBuilder builder() {
                return new ServiceBuilder();
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public String getId() {
                return this.id;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public String getLabel() {
                return this.label;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public String getProvider() {
                return this.provider;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public String getVersion() {
                return this.version;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public boolean equals(final java.lang.Object o) {
                if (o == this) return true;
                if (!(o instanceof ServiceInstance.Plan.Service)) return false;
                final Service other = (Service)o;
                final java.lang.Object this$id = this.getId();
                final java.lang.Object other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
                final java.lang.Object this$label = this.getLabel();
                final java.lang.Object other$label = other.getLabel();
                if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
                final java.lang.Object this$provider = this.getProvider();
                final java.lang.Object other$provider = other.getProvider();
                if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) return false;
                final java.lang.Object this$version = this.getVersion();
                final java.lang.Object other$version = other.getVersion();
                if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
                return true;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public int hashCode() {
                final int PRIME = 59;
                int result = 1;
                final java.lang.Object $id = this.getId();
                result = result * PRIME + ($id == null ? 43 : $id.hashCode());
                final java.lang.Object $label = this.getLabel();
                result = result * PRIME + ($label == null ? 43 : $label.hashCode());
                final java.lang.Object $provider = this.getProvider();
                result = result * PRIME + ($provider == null ? 43 : $provider.hashCode());
                final java.lang.Object $version = this.getVersion();
                result = result * PRIME + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "ServiceInstance.Plan.Service(id=" + this.getId() + ", label=" + this.getLabel() + ", provider=" + this.getProvider() + ", version=" + this.getVersion() + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static class PlanBuilder {
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String id;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String name;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Service service;

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            PlanBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PlanBuilder id(final String id) {
                this.id = id;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PlanBuilder name(final String name) {
                this.name = name;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PlanBuilder service(final Service service) {
                this.service = service;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Plan build() {
                return new Plan(id, name, service);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "ServiceInstance.Plan.PlanBuilder(id=" + this.id + ", name=" + this.name + ", service=" + this.service + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static PlanBuilder builder() {
            return new PlanBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getId() {
            return this.id;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getName() {
            return this.name;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Service getService() {
            return this.service;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ServiceInstance.Plan)) return false;
            final Plan other = (Plan)o;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$name = this.getName();
            final java.lang.Object other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
            final java.lang.Object this$service = this.getService();
            final java.lang.Object other$service = other.getService();
            if (this$service == null ? other$service != null : !this$service.equals(other$service)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $name = this.getName();
            result = result * PRIME + ($name == null ? 43 : $name.hashCode());
            final java.lang.Object $service = this.getService();
            result = result * PRIME + ($service == null ? 43 : $service.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ServiceInstance.Plan(id=" + this.getId() + ", name=" + this.getName() + ", service=" + this.getService() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ServiceInstanceBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer boundApplicationCount;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String dashboardUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String id;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private LastOperation lastOperation;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Plan servicePlan;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ServiceInstanceBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceBuilder boundApplicationCount(final Integer boundApplicationCount) {
            this.boundApplicationCount = boundApplicationCount;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceBuilder dashboardUrl(final String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceBuilder id(final String id) {
            this.id = id;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceBuilder lastOperation(final LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceBuilder servicePlan(final Plan servicePlan) {
            this.servicePlan = servicePlan;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstance build() {
            return new ServiceInstance(boundApplicationCount, dashboardUrl, id, lastOperation, name, servicePlan);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ServiceInstance.ServiceInstanceBuilder(boundApplicationCount=" + this.boundApplicationCount + ", dashboardUrl=" + this.dashboardUrl + ", id=" + this.id + ", lastOperation=" + this.lastOperation + ", name=" + this.name + ", servicePlan=" + this.servicePlan + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ServiceInstanceBuilder builder() {
        return new ServiceInstanceBuilder();
    }

    /**
     * The bound application count
     *
     * @return the bound application count
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getBoundApplicationCount() {
        return this.boundApplicationCount;
    }

    /**
     * The dashboard url
     *
     * @return the dashboard url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    /**
     * The id
     *
     * @return the id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    /**
     * The last operation
     *
     * @return the last operation
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The service plan
     *
     * @return the service plan
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Plan getServicePlan() {
        return this.servicePlan;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServiceInstance)) return false;
        final ServiceInstance other = (ServiceInstance)o;
        final java.lang.Object this$boundApplicationCount = this.getBoundApplicationCount();
        final java.lang.Object other$boundApplicationCount = other.getBoundApplicationCount();
        if (this$boundApplicationCount == null ? other$boundApplicationCount != null : !this$boundApplicationCount.equals(other$boundApplicationCount)) return false;
        final java.lang.Object this$dashboardUrl = this.getDashboardUrl();
        final java.lang.Object other$dashboardUrl = other.getDashboardUrl();
        if (this$dashboardUrl == null ? other$dashboardUrl != null : !this$dashboardUrl.equals(other$dashboardUrl)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$lastOperation = this.getLastOperation();
        final java.lang.Object other$lastOperation = other.getLastOperation();
        if (this$lastOperation == null ? other$lastOperation != null : !this$lastOperation.equals(other$lastOperation)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$servicePlan = this.getServicePlan();
        final java.lang.Object other$servicePlan = other.getServicePlan();
        if (this$servicePlan == null ? other$servicePlan != null : !this$servicePlan.equals(other$servicePlan)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $boundApplicationCount = this.getBoundApplicationCount();
        result = result * PRIME + ($boundApplicationCount == null ? 43 : $boundApplicationCount.hashCode());
        final java.lang.Object $dashboardUrl = this.getDashboardUrl();
        result = result * PRIME + ($dashboardUrl == null ? 43 : $dashboardUrl.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $lastOperation = this.getLastOperation();
        result = result * PRIME + ($lastOperation == null ? 43 : $lastOperation.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $servicePlan = this.getServicePlan();
        result = result * PRIME + ($servicePlan == null ? 43 : $servicePlan.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ServiceInstance(boundApplicationCount=" + this.getBoundApplicationCount() + ", dashboardUrl=" + this.getDashboardUrl() + ", id=" + this.getId() + ", lastOperation=" + this.getLastOperation() + ", name=" + this.getName() + ", servicePlan=" + this.getServicePlan() + ")";
    }
}