// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * The entity response payload for Service Instances
 */
public final class ServiceInstanceEntity {
    
    /**
     * The credentials
     *
     * @param credentials the credentials
     */
    private final Map<String, Object> credentials;
    
    /**
     * The dashboard url
     *
     * @param dashboardUrl the dashboard url
     */
    private final String dashboardUrl;
    
    /**
     * The gateway data
     *
     * @param gatewayData the gateway data
     */
    private final String gatewayData;
    
    /**
     * The last operation
     *
     * @param lastOperation the last operation
     */
    private final LastOperation lastOperation;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The routes url
     *
     * @param routesUrl the routes url
     */
    private final String routesUrl;
    
    /**
     * The service bindings url
     *
     * @param serviceBindingsUrl the service bindings url
     */
    private final String serviceBindingsUrl;
    
    /**
     * The service keys url
     *
     * @param serviceKeysUrl the service keys url
     */
    private final String serviceKeysUrl;
    
    /**
     * The service plan id
     *
     * @param servicePlanId the service plan id
     */
    private final String servicePlanId;
    
    /**
     * The service plan url
     *
     * @param servicePlanUrl the service plan url
     */
    private final String servicePlanUrl;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * The space url
     *
     * @param spaceUrl the space url
     */
    private final String spaceUrl;
    
    /**
     * The tags
     *
     * @param tags the tags
     */
    private final List<String> tags;
    
    /**
     * The type
     *
     * @param type the type
     */
    private final String type;

    ServiceInstanceEntity(@JsonProperty("credentials") Map<String, Object> credentials, @JsonProperty("dashboard_url") String dashboardUrl, @JsonProperty("gateway_data") @Deprecated String gatewayData, @JsonProperty("last_operation") LastOperation lastOperation, @JsonProperty("name") String name, @JsonProperty("routes_url") String routesUrl, @JsonProperty("service_bindings_url") String serviceBindingsUrl, @JsonProperty("service_keys_url") String serviceKeysUrl, @JsonProperty("service_plan_guid") String servicePlanId, @JsonProperty("service_plan_url") String servicePlanUrl, @JsonProperty("space_guid") String spaceId, @JsonProperty("space_url") String spaceUrl, @JsonProperty("tags") List<String> tags, @JsonProperty("type") String type) {
        this.credentials = credentials;
        this.dashboardUrl = dashboardUrl;
        this.gatewayData = gatewayData;
        this.lastOperation = lastOperation;
        this.name = name;
        this.routesUrl = routesUrl;
        this.serviceBindingsUrl = serviceBindingsUrl;
        this.serviceKeysUrl = serviceKeysUrl;
        this.servicePlanId = servicePlanId;
        this.servicePlanUrl = servicePlanUrl;
        this.spaceId = spaceId;
        this.spaceUrl = spaceUrl;
        this.tags = tags;
        this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ServiceInstanceEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> credentials$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> credentials$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String dashboardUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String gatewayData;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private LastOperation lastOperation;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routesUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceBindingsUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceKeysUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> tags;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String type;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ServiceInstanceEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder credential(final String credentialKey, final Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder credentials(final java.util.Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder dashboardUrl(final String dashboardUrl) {
            this.dashboardUrl = dashboardUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder gatewayData(final String gatewayData) {
            this.gatewayData = gatewayData;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder lastOperation(final LastOperation lastOperation) {
            this.lastOperation = lastOperation;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder routesUrl(final String routesUrl) {
            this.routesUrl = routesUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder serviceBindingsUrl(final String serviceBindingsUrl) {
            this.serviceBindingsUrl = serviceBindingsUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder serviceKeysUrl(final String serviceKeysUrl) {
            this.serviceKeysUrl = serviceKeysUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder servicePlanId(final String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder servicePlanUrl(final String servicePlanUrl) {
            this.servicePlanUrl = servicePlanUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder spaceUrl(final String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder tag(final String tag) {
            if (this.tags == null) this.tags = new java.util.ArrayList<String>();
            this.tags.add(tag);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder tags(final java.util.Collection<? extends String> tags) {
            if (this.tags == null) this.tags = new java.util.ArrayList<String>();
            this.tags.addAll(tags);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntityBuilder type(final String type) {
            this.type = type;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceInstanceEntity build() {
            java.util.Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
            case 0: 
                credentials = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                credentials = java.util.Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                break;
            
            default: 
                credentials = new java.util.LinkedHashMap<String, Object>(this.credentials$key.size() < 1073741824 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.credentials$key.size(); $i++) credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                credentials = java.util.Collections.unmodifiableMap(credentials);
            
            }
            java.util.List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
            case 0: 
                tags = java.util.Collections.emptyList();
                break;
            
            case 1: 
                tags = java.util.Collections.singletonList(this.tags.get(0));
                break;
            
            default: 
                tags = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.tags));
            
            }
            return new ServiceInstanceEntity(credentials, dashboardUrl, gatewayData, lastOperation, name, routesUrl, serviceBindingsUrl, serviceKeysUrl, servicePlanId, servicePlanUrl, spaceId, spaceUrl, tags, type);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ServiceInstanceEntity.ServiceInstanceEntityBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", dashboardUrl=" + this.dashboardUrl + ", gatewayData=" + this.gatewayData + ", lastOperation=" + this.lastOperation + ", name=" + this.name + ", routesUrl=" + this.routesUrl + ", serviceBindingsUrl=" + this.serviceBindingsUrl + ", serviceKeysUrl=" + this.serviceKeysUrl + ", servicePlanId=" + this.servicePlanId + ", servicePlanUrl=" + this.servicePlanUrl + ", spaceId=" + this.spaceId + ", spaceUrl=" + this.spaceUrl + ", tags=" + this.tags + ", type=" + this.type + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ServiceInstanceEntityBuilder builder() {
        return new ServiceInstanceEntityBuilder();
    }

    /**
     * The credentials
     *
     * @return the credentials
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    /**
     * The dashboard url
     *
     * @return the dashboard url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    /**
     * The last operation
     *
     * @return the last operation
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public LastOperation getLastOperation() {
        return this.lastOperation;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The routes url
     *
     * @return the routes url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRoutesUrl() {
        return this.routesUrl;
    }

    /**
     * The service bindings url
     *
     * @return the service bindings url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceBindingsUrl() {
        return this.serviceBindingsUrl;
    }

    /**
     * The service keys url
     *
     * @return the service keys url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceKeysUrl() {
        return this.serviceKeysUrl;
    }

    /**
     * The service plan id
     *
     * @return the service plan id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    /**
     * The service plan url
     *
     * @return the service plan url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanUrl() {
        return this.servicePlanUrl;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The space url
     *
     * @return the space url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    /**
     * The tags
     *
     * @return the tags
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getTags() {
        return this.tags;
    }

    /**
     * The type
     *
     * @return the type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getType() {
        return this.type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServiceInstanceEntity)) return false;
        final ServiceInstanceEntity other = (ServiceInstanceEntity)o;
        final java.lang.Object this$credentials = this.getCredentials();
        final java.lang.Object other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) return false;
        final java.lang.Object this$dashboardUrl = this.getDashboardUrl();
        final java.lang.Object other$dashboardUrl = other.getDashboardUrl();
        if (this$dashboardUrl == null ? other$dashboardUrl != null : !this$dashboardUrl.equals(other$dashboardUrl)) return false;
        final java.lang.Object this$gatewayData = this.getGatewayData();
        final java.lang.Object other$gatewayData = other.getGatewayData();
        if (this$gatewayData == null ? other$gatewayData != null : !this$gatewayData.equals(other$gatewayData)) return false;
        final java.lang.Object this$lastOperation = this.getLastOperation();
        final java.lang.Object other$lastOperation = other.getLastOperation();
        if (this$lastOperation == null ? other$lastOperation != null : !this$lastOperation.equals(other$lastOperation)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$routesUrl = this.getRoutesUrl();
        final java.lang.Object other$routesUrl = other.getRoutesUrl();
        if (this$routesUrl == null ? other$routesUrl != null : !this$routesUrl.equals(other$routesUrl)) return false;
        final java.lang.Object this$serviceBindingsUrl = this.getServiceBindingsUrl();
        final java.lang.Object other$serviceBindingsUrl = other.getServiceBindingsUrl();
        if (this$serviceBindingsUrl == null ? other$serviceBindingsUrl != null : !this$serviceBindingsUrl.equals(other$serviceBindingsUrl)) return false;
        final java.lang.Object this$serviceKeysUrl = this.getServiceKeysUrl();
        final java.lang.Object other$serviceKeysUrl = other.getServiceKeysUrl();
        if (this$serviceKeysUrl == null ? other$serviceKeysUrl != null : !this$serviceKeysUrl.equals(other$serviceKeysUrl)) return false;
        final java.lang.Object this$servicePlanId = this.getServicePlanId();
        final java.lang.Object other$servicePlanId = other.getServicePlanId();
        if (this$servicePlanId == null ? other$servicePlanId != null : !this$servicePlanId.equals(other$servicePlanId)) return false;
        final java.lang.Object this$servicePlanUrl = this.getServicePlanUrl();
        final java.lang.Object other$servicePlanUrl = other.getServicePlanUrl();
        if (this$servicePlanUrl == null ? other$servicePlanUrl != null : !this$servicePlanUrl.equals(other$servicePlanUrl)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        final java.lang.Object this$spaceUrl = this.getSpaceUrl();
        final java.lang.Object other$spaceUrl = other.getSpaceUrl();
        if (this$spaceUrl == null ? other$spaceUrl != null : !this$spaceUrl.equals(other$spaceUrl)) return false;
        final java.lang.Object this$tags = this.getTags();
        final java.lang.Object other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $credentials = this.getCredentials();
        result = result * PRIME + ($credentials == null ? 43 : $credentials.hashCode());
        final java.lang.Object $dashboardUrl = this.getDashboardUrl();
        result = result * PRIME + ($dashboardUrl == null ? 43 : $dashboardUrl.hashCode());
        final java.lang.Object $gatewayData = this.getGatewayData();
        result = result * PRIME + ($gatewayData == null ? 43 : $gatewayData.hashCode());
        final java.lang.Object $lastOperation = this.getLastOperation();
        result = result * PRIME + ($lastOperation == null ? 43 : $lastOperation.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $routesUrl = this.getRoutesUrl();
        result = result * PRIME + ($routesUrl == null ? 43 : $routesUrl.hashCode());
        final java.lang.Object $serviceBindingsUrl = this.getServiceBindingsUrl();
        result = result * PRIME + ($serviceBindingsUrl == null ? 43 : $serviceBindingsUrl.hashCode());
        final java.lang.Object $serviceKeysUrl = this.getServiceKeysUrl();
        result = result * PRIME + ($serviceKeysUrl == null ? 43 : $serviceKeysUrl.hashCode());
        final java.lang.Object $servicePlanId = this.getServicePlanId();
        result = result * PRIME + ($servicePlanId == null ? 43 : $servicePlanId.hashCode());
        final java.lang.Object $servicePlanUrl = this.getServicePlanUrl();
        result = result * PRIME + ($servicePlanUrl == null ? 43 : $servicePlanUrl.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        final java.lang.Object $spaceUrl = this.getSpaceUrl();
        result = result * PRIME + ($spaceUrl == null ? 43 : $spaceUrl.hashCode());
        final java.lang.Object $tags = this.getTags();
        result = result * PRIME + ($tags == null ? 43 : $tags.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ServiceInstanceEntity(credentials=" + this.getCredentials() + ", dashboardUrl=" + this.getDashboardUrl() + ", gatewayData=" + this.getGatewayData() + ", lastOperation=" + this.getLastOperation() + ", name=" + this.getName() + ", routesUrl=" + this.getRoutesUrl() + ", serviceBindingsUrl=" + this.getServiceBindingsUrl() + ", serviceKeysUrl=" + this.getServiceKeysUrl() + ", servicePlanId=" + this.getServicePlanId() + ", servicePlanUrl=" + this.getServicePlanUrl() + ", spaceId=" + this.getSpaceId() + ", spaceUrl=" + this.getSpaceUrl() + ", tags=" + this.getTags() + ", type=" + this.getType() + ")";
    }

    /**
     * The gateway data
     *
     * @return the gateway data
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getGatewayData() {
        return this.gatewayData;
    }
}