// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.Map;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the Create Service Key
 */
public final class CreateServiceKeyRequest implements Validatable {
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * Key/value pairs of all arbitrary parameters to pass along to the service broker
     *
     * @param parameters the arbitrary parameters to pass along to the service broker
     */
    private final Map<String, Object> parameters;
    
    /**
     * The service instance id
     *
     * @param serviceInstanceId the service instance id
     */
    private final String serviceInstanceId;

    CreateServiceKeyRequest(String name, Map<String, Object> parameters, String serviceInstanceId) {
        this.name = name;
        this.parameters = parameters;
        this.serviceInstanceId = serviceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.serviceInstanceId == null) {
            builder.message("service instance id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateServiceKeyRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> parameters$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> parameters$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceInstanceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateServiceKeyRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceKeyRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceKeyRequestBuilder parameter(final String parameterKey, final Object parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new java.util.ArrayList<String>();
                this.parameters$value = new java.util.ArrayList<Object>();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceKeyRequestBuilder parameters(final java.util.Map<? extends String, ? extends Object> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new java.util.ArrayList<String>();
                this.parameters$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceKeyRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServiceKeyRequest build() {
            java.util.Map<String, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
            case 0: 
                parameters = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                parameters = java.util.Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                break;
            
            default: 
                parameters = new java.util.LinkedHashMap<String, Object>(this.parameters$key.size() < 1073741824 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.parameters$key.size(); $i++) parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                parameters = java.util.Collections.unmodifiableMap(parameters);
            
            }
            return new CreateServiceKeyRequest(name, parameters, serviceInstanceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateServiceKeyRequest.CreateServiceKeyRequestBuilder(name=" + this.name + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ", serviceInstanceId=" + this.serviceInstanceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateServiceKeyRequestBuilder builder() {
        return new CreateServiceKeyRequestBuilder();
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * Key/value pairs of all arbitrary parameters to pass along to the service broker
     *
     * @return the arbitrary parameters to pass along to the service broker
     */
    @JsonProperty("parameters")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    /**
     * The service instance id
     *
     * @return the service instance id
     */
    @JsonProperty("service_instance_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }
}