// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServiceKeyRequest implements Validatable {
    
    /**
     * The service key id
     *
     * @param serviceKeyId the service key id
     */
    private final String serviceKeyId;

    DeleteServiceKeyRequest(String serviceKeyId) {
        this.serviceKeyId = serviceKeyId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceKeyId == null) {
            builder.message("service key id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeleteServiceKeyRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceKeyId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeleteServiceKeyRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceKeyRequestBuilder serviceKeyId(final String serviceKeyId) {
            this.serviceKeyId = serviceKeyId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceKeyRequest build() {
            return new DeleteServiceKeyRequest(serviceKeyId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeleteServiceKeyRequest.DeleteServiceKeyRequestBuilder(serviceKeyId=" + this.serviceKeyId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeleteServiceKeyRequestBuilder builder() {
        return new DeleteServiceKeyRequestBuilder();
    }

    /**
     * The service key id
     *
     * @return the service key id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceKeyId() {
        return this.serviceKeyId;
    }
}