// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicekeys;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List Service Keys operation
 */
public final class ListServiceKeysRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The service instance ids
     *
     * @param serviceInstanceIds the service instance ids
     */
    private final List<String> serviceInstanceIds;

    ListServiceKeysRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServiceKeysRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceInstanceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServiceKeysRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequestBuilder serviceInstanceIds(final java.util.Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceKeysRequest build() {
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            java.util.List<String> serviceInstanceIds;
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
            case 0: 
                serviceInstanceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceInstanceIds = java.util.Collections.singletonList(this.serviceInstanceIds.get(0));
                break;
            
            default: 
                serviceInstanceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceInstanceIds));
            
            }
            return new ListServiceKeysRequest(orderDirection, page, resultsPerPage, names, serviceInstanceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServiceKeysRequest.ListServiceKeysRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServiceKeysRequestBuilder builder() {
        return new ListServiceKeysRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServiceKeysRequest)) return false;
        final ListServiceKeysRequest other = (ListServiceKeysRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$serviceInstanceIds = this.getServiceInstanceIds();
        final java.lang.Object other$serviceInstanceIds = other.getServiceInstanceIds();
        if (this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !this$serviceInstanceIds.equals(other$serviceInstanceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServiceKeysRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * PRIME + ($serviceInstanceIds == null ? 43 : $serviceInstanceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServiceKeysRequest(super=" + super.toString() + ", names=" + this.getNames() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    /**
     * The names
     *
     * @return the names
     */
    @InFilterParameter("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The service instance ids
     *
     * @return the service instance ids
     */
    @InFilterParameter("service_instance_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }
}