// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * The entity response payload for Service Keys
 */
public final class ServiceKeyEntity {
    
    /**
     * The credentials
     *
     * @param credentials the credentials
     */
    private final Map<String, Object> credentials;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The service instance id
     *
     * @param serviceInstanceId the service instance id
     */
    private final String serviceInstanceId;
    
    /**
     * The service instance url
     *
     * @param serviceInstanceId the service instance url
     */
    private final String serviceInstanceUrl;

    ServiceKeyEntity(@JsonProperty("credentials") Map<String, Object> credentials, @JsonProperty("name") String name, @JsonProperty("service_instance_guid") String serviceInstanceId, @JsonProperty("service_instance_url") String serviceInstanceUrl) {
        this.credentials = credentials;
        this.name = name;
        this.serviceInstanceId = serviceInstanceId;
        this.serviceInstanceUrl = serviceInstanceUrl;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ServiceKeyEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> credentials$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> credentials$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceInstanceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceInstanceUrl;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ServiceKeyEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceKeyEntityBuilder credential(final String credentialKey, final Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceKeyEntityBuilder credentials(final java.util.Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceKeyEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceKeyEntityBuilder serviceInstanceId(final String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceKeyEntityBuilder serviceInstanceUrl(final String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceKeyEntity build() {
            java.util.Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
            case 0: 
                credentials = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                credentials = java.util.Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                break;
            
            default: 
                credentials = new java.util.LinkedHashMap<String, Object>(this.credentials$key.size() < 1073741824 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.credentials$key.size(); $i++) credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                credentials = java.util.Collections.unmodifiableMap(credentials);
            
            }
            return new ServiceKeyEntity(credentials, name, serviceInstanceId, serviceInstanceUrl);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ServiceKeyEntity.ServiceKeyEntityBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", name=" + this.name + ", serviceInstanceId=" + this.serviceInstanceId + ", serviceInstanceUrl=" + this.serviceInstanceUrl + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ServiceKeyEntityBuilder builder() {
        return new ServiceKeyEntityBuilder();
    }

    /**
     * The credentials
     *
     * @return the credentials
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The service instance id
     *
     * @return the service instance id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    /**
     * The service instance url
     *
     * @return the service instance url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceInstanceUrl() {
        return this.serviceInstanceUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServiceKeyEntity)) return false;
        final ServiceKeyEntity other = (ServiceKeyEntity)o;
        final java.lang.Object this$credentials = this.getCredentials();
        final java.lang.Object other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$serviceInstanceId = this.getServiceInstanceId();
        final java.lang.Object other$serviceInstanceId = other.getServiceInstanceId();
        if (this$serviceInstanceId == null ? other$serviceInstanceId != null : !this$serviceInstanceId.equals(other$serviceInstanceId)) return false;
        final java.lang.Object this$serviceInstanceUrl = this.getServiceInstanceUrl();
        final java.lang.Object other$serviceInstanceUrl = other.getServiceInstanceUrl();
        if (this$serviceInstanceUrl == null ? other$serviceInstanceUrl != null : !this$serviceInstanceUrl.equals(other$serviceInstanceUrl)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $credentials = this.getCredentials();
        result = result * PRIME + ($credentials == null ? 43 : $credentials.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $serviceInstanceId = this.getServiceInstanceId();
        result = result * PRIME + ($serviceInstanceId == null ? 43 : $serviceInstanceId.hashCode());
        final java.lang.Object $serviceInstanceUrl = this.getServiceInstanceUrl();
        result = result * PRIME + ($serviceInstanceUrl == null ? 43 : $serviceInstanceUrl.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ServiceKeyEntity(credentials=" + this.getCredentials() + ", name=" + this.getName() + ", serviceInstanceId=" + this.getServiceInstanceId() + ", serviceInstanceUrl=" + this.getServiceInstanceUrl() + ")";
    }
}