// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Get Service Plan operation
 */
public final class GetServicePlanRequest implements Validatable {
    
    /**
     * The service plan id
     *
     * @param servicePlanId the service plan id
     */
    private final String servicePlanId;

    GetServicePlanRequest(String servicePlanId) {
        this.servicePlanId = servicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetServicePlanRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetServicePlanRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServicePlanRequestBuilder servicePlanId(final String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServicePlanRequest build() {
            return new GetServicePlanRequest(servicePlanId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetServicePlanRequest.GetServicePlanRequestBuilder(servicePlanId=" + this.servicePlanId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetServicePlanRequestBuilder builder() {
        return new GetServicePlanRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetServicePlanRequest)) return false;
        final GetServicePlanRequest other = (GetServicePlanRequest)o;
        final java.lang.Object this$servicePlanId = this.getServicePlanId();
        final java.lang.Object other$servicePlanId = other.getServicePlanId();
        if (this$servicePlanId == null ? other$servicePlanId != null : !this$servicePlanId.equals(other$servicePlanId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $servicePlanId = this.getServicePlanId();
        result = result * PRIME + ($servicePlanId == null ? 43 : $servicePlanId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetServicePlanRequest(servicePlanId=" + this.getServicePlanId() + ")";
    }

    /**
     * The service plan id
     *
     * @return the service plan id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanId() {
        return this.servicePlanId;
    }
}