// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service Instances for the Service Plan operation
 */
public final class ListServicePlanServiceInstancesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The gateway names
     *
     * @param gatewayNames the gateway names to filter on
     */
    private final List<String> gatewayNames;
    
    /**
     * The names of the service instances
     *
     * @param names the names of the service instances to filter on
     */
    private final List<String> names;
    
    /**
     * The service binding ids
     *
     * @param serviceBindingIds the service binding ids to filter on
     */
    private final List<String> serviceBindingIds;
    
    /**
     * The service key ids
     *
     * @param serviceKeyIds the service key ids to filter on
     */
    private final List<String> serviceKeyIds;
    
    /**
     * The service plan id
     *
     * @param servicePlanId the service plan id
     */
    private final String servicePlanId;
    
    /**
     * The space ids
     *
     * @param spaceIds the space ids to filter on
     */
    private final List<String> spaceIds;

    ListServicePlanServiceInstancesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> gatewayNames, List<String> names, List<String> serviceBindingIds, List<String> serviceKeyIds, String servicePlanId, List<String> spaceIds) {
        super(orderDirection, page, resultsPerPage);
        this.gatewayNames = gatewayNames;
        this.names = names;
        this.serviceBindingIds = serviceBindingIds;
        this.serviceKeyIds = serviceKeyIds;
        this.servicePlanId = servicePlanId;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServicePlanServiceInstancesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> gatewayNames;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceBindingIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceKeyIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> spaceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServicePlanServiceInstancesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder gatewayName(final String gatewayName) {
            if (this.gatewayNames == null) this.gatewayNames = new java.util.ArrayList<String>();
            this.gatewayNames.add(gatewayName);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder gatewayNames(final java.util.Collection<? extends String> gatewayNames) {
            if (this.gatewayNames == null) this.gatewayNames = new java.util.ArrayList<String>();
            this.gatewayNames.addAll(gatewayNames);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder serviceBindingId(final String serviceBindingId) {
            if (this.serviceBindingIds == null) this.serviceBindingIds = new java.util.ArrayList<String>();
            this.serviceBindingIds.add(serviceBindingId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder serviceBindingIds(final java.util.Collection<? extends String> serviceBindingIds) {
            if (this.serviceBindingIds == null) this.serviceBindingIds = new java.util.ArrayList<String>();
            this.serviceBindingIds.addAll(serviceBindingIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder serviceKeyId(final String serviceKeyId) {
            if (this.serviceKeyIds == null) this.serviceKeyIds = new java.util.ArrayList<String>();
            this.serviceKeyIds.add(serviceKeyId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder serviceKeyIds(final java.util.Collection<? extends String> serviceKeyIds) {
            if (this.serviceKeyIds == null) this.serviceKeyIds = new java.util.ArrayList<String>();
            this.serviceKeyIds.addAll(serviceKeyIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder servicePlanId(final String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder spaceId(final String spaceId) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.add(spaceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequestBuilder spaceIds(final java.util.Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanServiceInstancesRequest build() {
            java.util.List<String> gatewayNames;
            switch (this.gatewayNames == null ? 0 : this.gatewayNames.size()) {
            case 0: 
                gatewayNames = java.util.Collections.emptyList();
                break;
            
            case 1: 
                gatewayNames = java.util.Collections.singletonList(this.gatewayNames.get(0));
                break;
            
            default: 
                gatewayNames = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.gatewayNames));
            
            }
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            java.util.List<String> serviceBindingIds;
            switch (this.serviceBindingIds == null ? 0 : this.serviceBindingIds.size()) {
            case 0: 
                serviceBindingIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceBindingIds = java.util.Collections.singletonList(this.serviceBindingIds.get(0));
                break;
            
            default: 
                serviceBindingIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceBindingIds));
            
            }
            java.util.List<String> serviceKeyIds;
            switch (this.serviceKeyIds == null ? 0 : this.serviceKeyIds.size()) {
            case 0: 
                serviceKeyIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceKeyIds = java.util.Collections.singletonList(this.serviceKeyIds.get(0));
                break;
            
            default: 
                serviceKeyIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceKeyIds));
            
            }
            java.util.List<String> spaceIds;
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
            case 0: 
                spaceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                spaceIds = java.util.Collections.singletonList(this.spaceIds.get(0));
                break;
            
            default: 
                spaceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.spaceIds));
            
            }
            return new ListServicePlanServiceInstancesRequest(orderDirection, page, resultsPerPage, gatewayNames, names, serviceBindingIds, serviceKeyIds, servicePlanId, spaceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServicePlanServiceInstancesRequest.ListServicePlanServiceInstancesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", gatewayNames=" + this.gatewayNames + ", names=" + this.names + ", serviceBindingIds=" + this.serviceBindingIds + ", serviceKeyIds=" + this.serviceKeyIds + ", servicePlanId=" + this.servicePlanId + ", spaceIds=" + this.spaceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServicePlanServiceInstancesRequestBuilder builder() {
        return new ListServicePlanServiceInstancesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServicePlanServiceInstancesRequest)) return false;
        final ListServicePlanServiceInstancesRequest other = (ListServicePlanServiceInstancesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$gatewayNames = this.getGatewayNames();
        final java.lang.Object other$gatewayNames = other.getGatewayNames();
        if (this$gatewayNames == null ? other$gatewayNames != null : !this$gatewayNames.equals(other$gatewayNames)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$serviceBindingIds = this.getServiceBindingIds();
        final java.lang.Object other$serviceBindingIds = other.getServiceBindingIds();
        if (this$serviceBindingIds == null ? other$serviceBindingIds != null : !this$serviceBindingIds.equals(other$serviceBindingIds)) return false;
        final java.lang.Object this$serviceKeyIds = this.getServiceKeyIds();
        final java.lang.Object other$serviceKeyIds = other.getServiceKeyIds();
        if (this$serviceKeyIds == null ? other$serviceKeyIds != null : !this$serviceKeyIds.equals(other$serviceKeyIds)) return false;
        final java.lang.Object this$servicePlanId = this.getServicePlanId();
        final java.lang.Object other$servicePlanId = other.getServicePlanId();
        if (this$servicePlanId == null ? other$servicePlanId != null : !this$servicePlanId.equals(other$servicePlanId)) return false;
        final java.lang.Object this$spaceIds = this.getSpaceIds();
        final java.lang.Object other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !this$spaceIds.equals(other$spaceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServicePlanServiceInstancesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $gatewayNames = this.getGatewayNames();
        result = result * PRIME + ($gatewayNames == null ? 43 : $gatewayNames.hashCode());
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $serviceBindingIds = this.getServiceBindingIds();
        result = result * PRIME + ($serviceBindingIds == null ? 43 : $serviceBindingIds.hashCode());
        final java.lang.Object $serviceKeyIds = this.getServiceKeyIds();
        result = result * PRIME + ($serviceKeyIds == null ? 43 : $serviceKeyIds.hashCode());
        final java.lang.Object $servicePlanId = this.getServicePlanId();
        result = result * PRIME + ($servicePlanId == null ? 43 : $servicePlanId.hashCode());
        final java.lang.Object $spaceIds = this.getSpaceIds();
        result = result * PRIME + ($spaceIds == null ? 43 : $spaceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServicePlanServiceInstancesRequest(super=" + super.toString() + ", gatewayNames=" + this.getGatewayNames() + ", names=" + this.getNames() + ", serviceBindingIds=" + this.getServiceBindingIds() + ", serviceKeyIds=" + this.getServiceKeyIds() + ", servicePlanId=" + this.getServicePlanId() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    /**
     * The gateway names
     *
     * @return the gateway names to filter on
     */
    @InFilterParameter("gateway_name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getGatewayNames() {
        return this.gatewayNames;
    }

    /**
     * The names of the service instances
     *
     * @return the names of the service instances to filter on
     */
    @InFilterParameter("names")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The service binding ids
     *
     * @return the service binding ids to filter on
     */
    @InFilterParameter("service_binding_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceBindingIds() {
        return this.serviceBindingIds;
    }

    /**
     * The service key ids
     *
     * @return the service key ids to filter on
     */
    @InFilterParameter("service_key_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceKeyIds() {
        return this.serviceKeyIds;
    }

    /**
     * The service plan id
     *
     * @return the service plan id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    /**
     * The space ids
     *
     * @return the space ids to filter on
     */
    @InFilterParameter("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }
}