// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplans;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List Service Plans operation
 */
public final class ListServicePlansRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The active flag
     *
     * @param active the active flag
     */
    private final Boolean active;
    
    /**
     * The service broker ids
     *
     * @param serviceBrokerIds the service broker ids
     */
    private final List<String> serviceBrokerIds;
    
    /**
     * The service ids
     *
     * @param serviceIds the service ids
     */
    private final List<String> serviceIds;
    
    /**
     * The service instance ids
     *
     * @param serviceInstanceIds the service instance ids
     */
    private final List<String> serviceInstanceIds;

    ListServicePlansRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean active, List<String> serviceBrokerIds, List<String> serviceIds, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.active = active;
        this.serviceBrokerIds = serviceBrokerIds;
        this.serviceIds = serviceIds;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServicePlansRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean active;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceBrokerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceInstanceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServicePlansRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder active(final Boolean active) {
            this.active = active;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder serviceBrokerId(final String serviceBrokerId) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder serviceBrokerIds(final java.util.Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder serviceId(final String serviceId) {
            if (this.serviceIds == null) this.serviceIds = new java.util.ArrayList<String>();
            this.serviceIds.add(serviceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder serviceIds(final java.util.Collection<? extends String> serviceIds) {
            if (this.serviceIds == null) this.serviceIds = new java.util.ArrayList<String>();
            this.serviceIds.addAll(serviceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequestBuilder serviceInstanceIds(final java.util.Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlansRequest build() {
            java.util.List<String> serviceBrokerIds;
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
            case 0: 
                serviceBrokerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceBrokerIds = java.util.Collections.singletonList(this.serviceBrokerIds.get(0));
                break;
            
            default: 
                serviceBrokerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceBrokerIds));
            
            }
            java.util.List<String> serviceIds;
            switch (this.serviceIds == null ? 0 : this.serviceIds.size()) {
            case 0: 
                serviceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceIds = java.util.Collections.singletonList(this.serviceIds.get(0));
                break;
            
            default: 
                serviceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceIds));
            
            }
            java.util.List<String> serviceInstanceIds;
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
            case 0: 
                serviceInstanceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceInstanceIds = java.util.Collections.singletonList(this.serviceInstanceIds.get(0));
                break;
            
            default: 
                serviceInstanceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceInstanceIds));
            
            }
            return new ListServicePlansRequest(orderDirection, page, resultsPerPage, active, serviceBrokerIds, serviceIds, serviceInstanceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServicePlansRequest.ListServicePlansRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", active=" + this.active + ", serviceBrokerIds=" + this.serviceBrokerIds + ", serviceIds=" + this.serviceIds + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServicePlansRequestBuilder builder() {
        return new ListServicePlansRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServicePlansRequest)) return false;
        final ListServicePlansRequest other = (ListServicePlansRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$active = this.getActive();
        final java.lang.Object other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
        final java.lang.Object this$serviceBrokerIds = this.getServiceBrokerIds();
        final java.lang.Object other$serviceBrokerIds = other.getServiceBrokerIds();
        if (this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !this$serviceBrokerIds.equals(other$serviceBrokerIds)) return false;
        final java.lang.Object this$serviceIds = this.getServiceIds();
        final java.lang.Object other$serviceIds = other.getServiceIds();
        if (this$serviceIds == null ? other$serviceIds != null : !this$serviceIds.equals(other$serviceIds)) return false;
        final java.lang.Object this$serviceInstanceIds = this.getServiceInstanceIds();
        final java.lang.Object other$serviceInstanceIds = other.getServiceInstanceIds();
        if (this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !this$serviceInstanceIds.equals(other$serviceInstanceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServicePlansRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $active = this.getActive();
        result = result * PRIME + ($active == null ? 43 : $active.hashCode());
        final java.lang.Object $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * PRIME + ($serviceBrokerIds == null ? 43 : $serviceBrokerIds.hashCode());
        final java.lang.Object $serviceIds = this.getServiceIds();
        result = result * PRIME + ($serviceIds == null ? 43 : $serviceIds.hashCode());
        final java.lang.Object $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * PRIME + ($serviceInstanceIds == null ? 43 : $serviceInstanceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServicePlansRequest(super=" + super.toString() + ", active=" + this.getActive() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ", serviceIds=" + this.getServiceIds() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    /**
     * The active flag
     *
     * @return the active flag
     */
    @InFilterParameter("active")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getActive() {
        return this.active;
    }

    /**
     * The service broker ids
     *
     * @return the service broker ids
     */
    @InFilterParameter("service_broker_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    /**
     * The service ids
     *
     * @return the service ids
     */
    @InFilterParameter("service_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    /**
     * The service instance ids
     *
     * @return the service instance ids
     */
    @InFilterParameter("service_instance_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }
}