// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Migrate Service Instances operation
 */
public final class MigrateServiceInstancesRequest implements Validatable {
    
    /**
     * The current service plan id
     *
     * @param currentServicePlanId the current service plan id
     */
    private final String currentServicePlanId;
    
    /**
     * The destination service plan id
     *
     * @param destinationServicePlanId the destination service plan id
     */
    private final String destinationServicePlanId;

    MigrateServiceInstancesRequest(String currentServicePlanId, String destinationServicePlanId) {
        this.currentServicePlanId = currentServicePlanId;
        this.destinationServicePlanId = destinationServicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.currentServicePlanId == null) {
            builder.message("current service plan id must be specified");
        }
        if (this.destinationServicePlanId == null) {
            builder.message("destination service plan id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class MigrateServiceInstancesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String currentServicePlanId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String destinationServicePlanId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        MigrateServiceInstancesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public MigrateServiceInstancesRequestBuilder currentServicePlanId(final String currentServicePlanId) {
            this.currentServicePlanId = currentServicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public MigrateServiceInstancesRequestBuilder destinationServicePlanId(final String destinationServicePlanId) {
            this.destinationServicePlanId = destinationServicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public MigrateServiceInstancesRequest build() {
            return new MigrateServiceInstancesRequest(currentServicePlanId, destinationServicePlanId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "MigrateServiceInstancesRequest.MigrateServiceInstancesRequestBuilder(currentServicePlanId=" + this.currentServicePlanId + ", destinationServicePlanId=" + this.destinationServicePlanId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static MigrateServiceInstancesRequestBuilder builder() {
        return new MigrateServiceInstancesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof MigrateServiceInstancesRequest)) return false;
        final MigrateServiceInstancesRequest other = (MigrateServiceInstancesRequest)o;
        final java.lang.Object this$currentServicePlanId = this.getCurrentServicePlanId();
        final java.lang.Object other$currentServicePlanId = other.getCurrentServicePlanId();
        if (this$currentServicePlanId == null ? other$currentServicePlanId != null : !this$currentServicePlanId.equals(other$currentServicePlanId)) return false;
        final java.lang.Object this$destinationServicePlanId = this.getDestinationServicePlanId();
        final java.lang.Object other$destinationServicePlanId = other.getDestinationServicePlanId();
        if (this$destinationServicePlanId == null ? other$destinationServicePlanId != null : !this$destinationServicePlanId.equals(other$destinationServicePlanId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $currentServicePlanId = this.getCurrentServicePlanId();
        result = result * PRIME + ($currentServicePlanId == null ? 43 : $currentServicePlanId.hashCode());
        final java.lang.Object $destinationServicePlanId = this.getDestinationServicePlanId();
        result = result * PRIME + ($destinationServicePlanId == null ? 43 : $destinationServicePlanId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "MigrateServiceInstancesRequest(currentServicePlanId=" + this.getCurrentServicePlanId() + ", destinationServicePlanId=" + this.getDestinationServicePlanId() + ")";
    }

    /**
     * The current service plan id
     *
     * @return the current service plan id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCurrentServicePlanId() {
        return this.currentServicePlanId;
    }

    /**
     * The destination service plan id
     *
     * @return the destination service plan id
     */
    @JsonProperty("service_plan_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDestinationServicePlanId() {
        return this.destinationServicePlanId;
    }
}