// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateServicePlanRequest implements Validatable {
    
    /**
     * Make the plan visible to all users
     *
     * @param publiclyVisible whether to make the plan visible to all users
     */
    private final Boolean publiclyVisible;
    
    /**
     * The service plan id
     *
     * @param servicePlanId the service plan id
     */
    private final String servicePlanId;

    UpdateServicePlanRequest(Boolean publiclyVisible, String servicePlanId) {
        this.publiclyVisible = publiclyVisible;
        this.servicePlanId = servicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateServicePlanRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean publiclyVisible;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateServicePlanRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServicePlanRequestBuilder publiclyVisible(final Boolean publiclyVisible) {
            this.publiclyVisible = publiclyVisible;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServicePlanRequestBuilder servicePlanId(final String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServicePlanRequest build() {
            return new UpdateServicePlanRequest(publiclyVisible, servicePlanId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateServicePlanRequest.UpdateServicePlanRequestBuilder(publiclyVisible=" + this.publiclyVisible + ", servicePlanId=" + this.servicePlanId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateServicePlanRequestBuilder builder() {
        return new UpdateServicePlanRequestBuilder();
    }

    /**
     * Make the plan visible to all users
     *
     * @return whether to make the plan visible to all users
     */
    @JsonProperty("public")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getPubliclyVisible() {
        return this.publiclyVisible;
    }

    /**
     * The service plan id
     *
     * @return the service plan id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanId() {
        return this.servicePlanId;
    }
}