// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Create Service Plan Visibility
 */
public final class CreateServicePlanVisibilityRequest implements Validatable {
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;
    
    /**
     * The service plan id
     *
     * @param servicePlanId the service plan id
     */
    private final String servicePlanId;

    CreateServicePlanVisibilityRequest(String organizationId, String servicePlanId) {
        this.organizationId = organizationId;
        this.servicePlanId = servicePlanId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateServicePlanVisibilityRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateServicePlanVisibilityRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServicePlanVisibilityRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServicePlanVisibilityRequestBuilder servicePlanId(final String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateServicePlanVisibilityRequest build() {
            return new CreateServicePlanVisibilityRequest(organizationId, servicePlanId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateServicePlanVisibilityRequest.CreateServicePlanVisibilityRequestBuilder(organizationId=" + this.organizationId + ", servicePlanId=" + this.servicePlanId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateServicePlanVisibilityRequestBuilder builder() {
        return new CreateServicePlanVisibilityRequestBuilder();
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonProperty("organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * The service plan id
     *
     * @return the service plan id
     */
    @JsonProperty("service_plan_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanId() {
        return this.servicePlanId;
    }
}