// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteServicePlanVisibilityRequest implements Validatable {
    
    /**
     * The async flag
     *
     * @param async  Will run the delete request in a background job. Recommended: 'true'.
     */
    private final Boolean async;
    
    /**
     * The service plan visibility id
     *
     * @param servicePlanVisibilityId the service plan visibility id
     */
    private final String servicePlanVisibilityId;

    DeleteServicePlanVisibilityRequest(Boolean async, String servicePlanVisibilityId) {
        this.async = async;
        this.servicePlanVisibilityId = servicePlanVisibilityId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanVisibilityId == null) {
            builder.message("service plan visibility id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeleteServicePlanVisibilityRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean async;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanVisibilityId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeleteServicePlanVisibilityRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServicePlanVisibilityRequestBuilder async(final Boolean async) {
            this.async = async;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServicePlanVisibilityRequestBuilder servicePlanVisibilityId(final String servicePlanVisibilityId) {
            this.servicePlanVisibilityId = servicePlanVisibilityId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServicePlanVisibilityRequest build() {
            return new DeleteServicePlanVisibilityRequest(async, servicePlanVisibilityId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeleteServicePlanVisibilityRequest.DeleteServicePlanVisibilityRequestBuilder(async=" + this.async + ", servicePlanVisibilityId=" + this.servicePlanVisibilityId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeleteServicePlanVisibilityRequestBuilder builder() {
        return new DeleteServicePlanVisibilityRequestBuilder();
    }

    /**
     * The async flag
     *
     * @return the async flag
     */
    @QueryParameter("async")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getAsync() {
        return this.async;
    }

    /**
     * The service plan visibility id
     *
     * @return the service plan visibility id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanVisibilityId() {
        return this.servicePlanVisibilityId;
    }
}