// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Get Service Plan Visibility operation
 */
public final class GetServicePlanVisibilityRequest implements Validatable {
    
    /**
     * The service plan visibility id
     *
     * @param servicePlanVisibilityId the service plan visibility id
     */
    private final String servicePlanVisibilityId;

    GetServicePlanVisibilityRequest(String servicePlanVisibilityId) {
        this.servicePlanVisibilityId = servicePlanVisibilityId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.servicePlanVisibilityId == null) {
            builder.message("service plan visibility id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetServicePlanVisibilityRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanVisibilityId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetServicePlanVisibilityRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServicePlanVisibilityRequestBuilder servicePlanVisibilityId(final String servicePlanVisibilityId) {
            this.servicePlanVisibilityId = servicePlanVisibilityId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServicePlanVisibilityRequest build() {
            return new GetServicePlanVisibilityRequest(servicePlanVisibilityId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetServicePlanVisibilityRequest.GetServicePlanVisibilityRequestBuilder(servicePlanVisibilityId=" + this.servicePlanVisibilityId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetServicePlanVisibilityRequestBuilder builder() {
        return new GetServicePlanVisibilityRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetServicePlanVisibilityRequest)) return false;
        final GetServicePlanVisibilityRequest other = (GetServicePlanVisibilityRequest)o;
        final java.lang.Object this$servicePlanVisibilityId = this.getServicePlanVisibilityId();
        final java.lang.Object other$servicePlanVisibilityId = other.getServicePlanVisibilityId();
        if (this$servicePlanVisibilityId == null ? other$servicePlanVisibilityId != null : !this$servicePlanVisibilityId.equals(other$servicePlanVisibilityId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $servicePlanVisibilityId = this.getServicePlanVisibilityId();
        result = result * PRIME + ($servicePlanVisibilityId == null ? 43 : $servicePlanVisibilityId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetServicePlanVisibilityRequest(servicePlanVisibilityId=" + this.getServicePlanVisibilityId() + ")";
    }

    /**
     * The service plan visibility id
     *
     * @return the service plan visibility id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanVisibilityId() {
        return this.servicePlanVisibilityId;
    }
}