// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service Service Plan Visibilities operation
 */
public final class ListServicePlanVisibilitiesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The organization ids
     *
     * @param organizationIds the organization ids
     */
    private final List<String> organizationIds;
    
    /**
     * The service plan ids
     *
     * @param servicePlanIds the service plan ids
     */
    private final List<String> servicePlanIds;

    ListServicePlanVisibilitiesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> organizationIds, List<String> servicePlanIds) {
        super(orderDirection, page, resultsPerPage);
        this.organizationIds = organizationIds;
        this.servicePlanIds = servicePlanIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServicePlanVisibilitiesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> organizationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> servicePlanIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServicePlanVisibilitiesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequestBuilder organizationId(final String organizationId) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.add(organizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequestBuilder organizationIds(final java.util.Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequestBuilder servicePlanId(final String servicePlanId) {
            if (this.servicePlanIds == null) this.servicePlanIds = new java.util.ArrayList<String>();
            this.servicePlanIds.add(servicePlanId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequestBuilder servicePlanIds(final java.util.Collection<? extends String> servicePlanIds) {
            if (this.servicePlanIds == null) this.servicePlanIds = new java.util.ArrayList<String>();
            this.servicePlanIds.addAll(servicePlanIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicePlanVisibilitiesRequest build() {
            java.util.List<String> organizationIds;
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
            case 0: 
                organizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                organizationIds = java.util.Collections.singletonList(this.organizationIds.get(0));
                break;
            
            default: 
                organizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.organizationIds));
            
            }
            java.util.List<String> servicePlanIds;
            switch (this.servicePlanIds == null ? 0 : this.servicePlanIds.size()) {
            case 0: 
                servicePlanIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                servicePlanIds = java.util.Collections.singletonList(this.servicePlanIds.get(0));
                break;
            
            default: 
                servicePlanIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.servicePlanIds));
            
            }
            return new ListServicePlanVisibilitiesRequest(orderDirection, page, resultsPerPage, organizationIds, servicePlanIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServicePlanVisibilitiesRequest.ListServicePlanVisibilitiesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", organizationIds=" + this.organizationIds + ", servicePlanIds=" + this.servicePlanIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServicePlanVisibilitiesRequestBuilder builder() {
        return new ListServicePlanVisibilitiesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServicePlanVisibilitiesRequest)) return false;
        final ListServicePlanVisibilitiesRequest other = (ListServicePlanVisibilitiesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$organizationIds = this.getOrganizationIds();
        final java.lang.Object other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !this$organizationIds.equals(other$organizationIds)) return false;
        final java.lang.Object this$servicePlanIds = this.getServicePlanIds();
        final java.lang.Object other$servicePlanIds = other.getServicePlanIds();
        if (this$servicePlanIds == null ? other$servicePlanIds != null : !this$servicePlanIds.equals(other$servicePlanIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServicePlanVisibilitiesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $organizationIds = this.getOrganizationIds();
        result = result * PRIME + ($organizationIds == null ? 43 : $organizationIds.hashCode());
        final java.lang.Object $servicePlanIds = this.getServicePlanIds();
        result = result * PRIME + ($servicePlanIds == null ? 43 : $servicePlanIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServicePlanVisibilitiesRequest(super=" + super.toString() + ", organizationIds=" + this.getOrganizationIds() + ", servicePlanIds=" + this.getServicePlanIds() + ")";
    }

    /**
     * The organization ids
     *
     * @return the organization ids
     */
    @InFilterParameter("organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    /**
     * The service plan ids
     *
     * @return the service plan ids
     */
    @InFilterParameter("service_plan_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }
}