// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Update Service Plan Visibility
 */
public final class UpdateServicePlanVisibilityRequest implements Validatable {
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;
    
    /**
     * The service plan id
     *
     * @param servicePlanId the service plan id
     */
    private final String servicePlanId;
    
    /**
     * The service plan visibility id
     *
     * @param servicePlanVisibilityId the service plan visibility id
     */
    private final String servicePlanVisibilityId;

    UpdateServicePlanVisibilityRequest(String organizationId, String servicePlanId, String servicePlanVisibilityId) {
        this.organizationId = organizationId;
        this.servicePlanId = servicePlanId;
        this.servicePlanVisibilityId = servicePlanVisibilityId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.servicePlanId == null) {
            builder.message("service plan id must be specified");
        }
        if (this.servicePlanVisibilityId == null) {
            builder.message("service plan visibility id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateServicePlanVisibilityRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlanVisibilityId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateServicePlanVisibilityRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServicePlanVisibilityRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServicePlanVisibilityRequestBuilder servicePlanId(final String servicePlanId) {
            this.servicePlanId = servicePlanId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServicePlanVisibilityRequestBuilder servicePlanVisibilityId(final String servicePlanVisibilityId) {
            this.servicePlanVisibilityId = servicePlanVisibilityId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateServicePlanVisibilityRequest build() {
            return new UpdateServicePlanVisibilityRequest(organizationId, servicePlanId, servicePlanVisibilityId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateServicePlanVisibilityRequest.UpdateServicePlanVisibilityRequestBuilder(organizationId=" + this.organizationId + ", servicePlanId=" + this.servicePlanId + ", servicePlanVisibilityId=" + this.servicePlanVisibilityId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateServicePlanVisibilityRequestBuilder builder() {
        return new UpdateServicePlanVisibilityRequestBuilder();
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonProperty("organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * The service plan id
     *
     * @return the service plan id
     */
    @JsonProperty("service_plan_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    /**
     * The service plan visibility id
     *
     * @return the service plan visibility id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlanVisibilityId() {
        return this.servicePlanVisibilityId;
    }
}