// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Delete Service operation.
 */
public final class DeleteServiceRequest implements Validatable {
    
    /**
     * The async flag
     *
     * @param async Will run the delete request in a background job. Recommended: 'true'.
     */
    private final Boolean async;
    
    /**
     * The purge flag
     *
     * @param purge Recursively remove a service and child objects from Cloud Foundry database without making requests to a service broker
     */
    private final Boolean purge;
    
    /**
     * The service id
     *
     * @param serviceId the service id
     */
    private final String serviceId;

    DeleteServiceRequest(Boolean async, Boolean purge, String serviceId) {
        this.async = async;
        this.purge = purge;
        this.serviceId = serviceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceId == null) {
            builder.message("service id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeleteServiceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean async;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean purge;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeleteServiceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceRequestBuilder async(final Boolean async) {
            this.async = async;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceRequestBuilder purge(final Boolean purge) {
            this.purge = purge;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceRequestBuilder serviceId(final String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteServiceRequest build() {
            return new DeleteServiceRequest(async, purge, serviceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeleteServiceRequest.DeleteServiceRequestBuilder(async=" + this.async + ", purge=" + this.purge + ", serviceId=" + this.serviceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeleteServiceRequestBuilder builder() {
        return new DeleteServiceRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DeleteServiceRequest)) return false;
        final DeleteServiceRequest other = (DeleteServiceRequest)o;
        final java.lang.Object this$async = this.getAsync();
        final java.lang.Object other$async = other.getAsync();
        if (this$async == null ? other$async != null : !this$async.equals(other$async)) return false;
        final java.lang.Object this$purge = this.getPurge();
        final java.lang.Object other$purge = other.getPurge();
        if (this$purge == null ? other$purge != null : !this$purge.equals(other$purge)) return false;
        final java.lang.Object this$serviceId = this.getServiceId();
        final java.lang.Object other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $async = this.getAsync();
        result = result * PRIME + ($async == null ? 43 : $async.hashCode());
        final java.lang.Object $purge = this.getPurge();
        result = result * PRIME + ($purge == null ? 43 : $purge.hashCode());
        final java.lang.Object $serviceId = this.getServiceId();
        result = result * PRIME + ($serviceId == null ? 43 : $serviceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "DeleteServiceRequest(async=" + this.getAsync() + ", purge=" + this.getPurge() + ", serviceId=" + this.getServiceId() + ")";
    }

    /**
     * The async flag
     *
     * @return the async flag
     */
    @QueryParameter("async")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getAsync() {
        return this.async;
    }

    /**
     * The purge flag
     *
     * @return the purge flag
     */
    @QueryParameter("purge")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getPurge() {
        return this.purge;
    }

    /**
     * The service id
     *
     * @return the binding id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceId() {
        return this.serviceId;
    }
}