// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service Plans for the Service operation
 */
public final class ListServiceServicePlansRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The active flag
     *
     * @param active the active flag
     */
    private final Boolean active;
    
    /**
     * The service broker ids
     *
     * @param serviceBrokerIds the service broker ids
     */
    private final List<String> serviceBrokerIds;
    
    /**
     * The service id
     *
     * @param serviceId the service id
     */
    private final String serviceId;
    
    /**
     * The service instance ids
     *
     * @param serviceInstanceIds the service instance ids
     */
    private final List<String> serviceInstanceIds;

    ListServiceServicePlansRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean active, List<String> serviceBrokerIds, String serviceId, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.active = active;
        this.serviceBrokerIds = serviceBrokerIds;
        this.serviceId = serviceId;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceId == null) {
            builder.message("service id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServiceServicePlansRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean active;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceBrokerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceInstanceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServiceServicePlansRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder active(final Boolean active) {
            this.active = active;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder serviceBrokerId(final String serviceBrokerId) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder serviceBrokerIds(final java.util.Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder serviceId(final String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequestBuilder serviceInstanceIds(final java.util.Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceServicePlansRequest build() {
            java.util.List<String> serviceBrokerIds;
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
            case 0: 
                serviceBrokerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceBrokerIds = java.util.Collections.singletonList(this.serviceBrokerIds.get(0));
                break;
            
            default: 
                serviceBrokerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceBrokerIds));
            
            }
            java.util.List<String> serviceInstanceIds;
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
            case 0: 
                serviceInstanceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceInstanceIds = java.util.Collections.singletonList(this.serviceInstanceIds.get(0));
                break;
            
            default: 
                serviceInstanceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceInstanceIds));
            
            }
            return new ListServiceServicePlansRequest(orderDirection, page, resultsPerPage, active, serviceBrokerIds, serviceId, serviceInstanceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServiceServicePlansRequest.ListServiceServicePlansRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", active=" + this.active + ", serviceBrokerIds=" + this.serviceBrokerIds + ", serviceId=" + this.serviceId + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServiceServicePlansRequestBuilder builder() {
        return new ListServiceServicePlansRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServiceServicePlansRequest)) return false;
        final ListServiceServicePlansRequest other = (ListServiceServicePlansRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$active = this.getActive();
        final java.lang.Object other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
        final java.lang.Object this$serviceBrokerIds = this.getServiceBrokerIds();
        final java.lang.Object other$serviceBrokerIds = other.getServiceBrokerIds();
        if (this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !this$serviceBrokerIds.equals(other$serviceBrokerIds)) return false;
        final java.lang.Object this$serviceId = this.getServiceId();
        final java.lang.Object other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) return false;
        final java.lang.Object this$serviceInstanceIds = this.getServiceInstanceIds();
        final java.lang.Object other$serviceInstanceIds = other.getServiceInstanceIds();
        if (this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !this$serviceInstanceIds.equals(other$serviceInstanceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServiceServicePlansRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $active = this.getActive();
        result = result * PRIME + ($active == null ? 43 : $active.hashCode());
        final java.lang.Object $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * PRIME + ($serviceBrokerIds == null ? 43 : $serviceBrokerIds.hashCode());
        final java.lang.Object $serviceId = this.getServiceId();
        result = result * PRIME + ($serviceId == null ? 43 : $serviceId.hashCode());
        final java.lang.Object $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * PRIME + ($serviceInstanceIds == null ? 43 : $serviceInstanceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServiceServicePlansRequest(super=" + super.toString() + ", active=" + this.getActive() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ", serviceId=" + this.getServiceId() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    /**
     * The active flag
     *
     * @return the active flag
     */
    @InFilterParameter("active")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getActive() {
        return this.active;
    }

    /**
     * The service broker ids
     *
     * @return the service broker ids
     */
    @InFilterParameter("service_broker_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    /**
     * The service id
     *
     * @return the service id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceId() {
        return this.serviceId;
    }

    /**
     * The service instance ids
     *
     * @return the service instance ids
     */
    @InFilterParameter("service_instance_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }
}