// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.services;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List Services operation
 */
public final class ListServicesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The active flag
     *
     * @param active the active flag
     */
    private final Boolean active;
    
    /**
     * The labels
     *
     * @param labels the labels
     */
    private final List<String> labels;
    
    /**
     * The providers
     *
     * @param providers the providers
     */
    private final List<String> providers;
    
    /**
     * The service broker ids
     *
     * @param serviceBrokerIds the service broker ids
     */
    private final List<String> serviceBrokerIds;

    ListServicesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean active, List<String> labels, List<String> providers, List<String> serviceBrokerIds) {
        super(orderDirection, page, resultsPerPage);
        this.active = active;
        this.labels = labels;
        this.providers = providers;
        this.serviceBrokerIds = serviceBrokerIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServicesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean active;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> labels;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> providers;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceBrokerIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServicesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder active(final Boolean active) {
            this.active = active;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder label(final String label) {
            if (this.labels == null) this.labels = new java.util.ArrayList<String>();
            this.labels.add(label);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder labels(final java.util.Collection<? extends String> labels) {
            if (this.labels == null) this.labels = new java.util.ArrayList<String>();
            this.labels.addAll(labels);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder provider(final String provider) {
            if (this.providers == null) this.providers = new java.util.ArrayList<String>();
            this.providers.add(provider);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder providers(final java.util.Collection<? extends String> providers) {
            if (this.providers == null) this.providers = new java.util.ArrayList<String>();
            this.providers.addAll(providers);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder serviceBrokerId(final String serviceBrokerId) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequestBuilder serviceBrokerIds(final java.util.Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesRequest build() {
            java.util.List<String> labels;
            switch (this.labels == null ? 0 : this.labels.size()) {
            case 0: 
                labels = java.util.Collections.emptyList();
                break;
            
            case 1: 
                labels = java.util.Collections.singletonList(this.labels.get(0));
                break;
            
            default: 
                labels = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.labels));
            
            }
            java.util.List<String> providers;
            switch (this.providers == null ? 0 : this.providers.size()) {
            case 0: 
                providers = java.util.Collections.emptyList();
                break;
            
            case 1: 
                providers = java.util.Collections.singletonList(this.providers.get(0));
                break;
            
            default: 
                providers = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.providers));
            
            }
            java.util.List<String> serviceBrokerIds;
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
            case 0: 
                serviceBrokerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceBrokerIds = java.util.Collections.singletonList(this.serviceBrokerIds.get(0));
                break;
            
            default: 
                serviceBrokerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceBrokerIds));
            
            }
            return new ListServicesRequest(orderDirection, page, resultsPerPage, active, labels, providers, serviceBrokerIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServicesRequest.ListServicesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", active=" + this.active + ", labels=" + this.labels + ", providers=" + this.providers + ", serviceBrokerIds=" + this.serviceBrokerIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServicesRequestBuilder builder() {
        return new ListServicesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServicesRequest)) return false;
        final ListServicesRequest other = (ListServicesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$active = this.getActive();
        final java.lang.Object other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
        final java.lang.Object this$labels = this.getLabels();
        final java.lang.Object other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !this$labels.equals(other$labels)) return false;
        final java.lang.Object this$providers = this.getProviders();
        final java.lang.Object other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !this$providers.equals(other$providers)) return false;
        final java.lang.Object this$serviceBrokerIds = this.getServiceBrokerIds();
        final java.lang.Object other$serviceBrokerIds = other.getServiceBrokerIds();
        if (this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !this$serviceBrokerIds.equals(other$serviceBrokerIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServicesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $active = this.getActive();
        result = result * PRIME + ($active == null ? 43 : $active.hashCode());
        final java.lang.Object $labels = this.getLabels();
        result = result * PRIME + ($labels == null ? 43 : $labels.hashCode());
        final java.lang.Object $providers = this.getProviders();
        result = result * PRIME + ($providers == null ? 43 : $providers.hashCode());
        final java.lang.Object $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * PRIME + ($serviceBrokerIds == null ? 43 : $serviceBrokerIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServicesRequest(super=" + super.toString() + ", active=" + this.getActive() + ", labels=" + this.getLabels() + ", providers=" + this.getProviders() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ")";
    }

    /**
     * The active flag
     *
     * @return the active flag
     */
    @InFilterParameter("active")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getActive() {
        return this.active;
    }

    /**
     * The labels
     *
     * @return the labels
     */
    @InFilterParameter("label")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getLabels() {
        return this.labels;
    }

    /**
     * The providers
     *
     * @return the providers
     */
    @InFilterParameter("provider")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getProviders() {
        return this.providers;
    }

    /**
     * The service broker ids
     *
     * @return the service broker ids
     */
    @InFilterParameter("service_broker_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }
}