// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.client.v2.PaginatedResponse;
import java.util.List;

/**
 * The response payload for the List Services operation
 */
public final class ListServicesResponse extends PaginatedResponse<ServiceResource> {

    ListServicesResponse(@JsonProperty("next_url") String nextUrl, @JsonProperty("prev_url") String previousUrl, @JsonProperty("resources") List<ServiceResource> resources, @JsonProperty("total_pages") Integer totalPages, @JsonProperty("total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServicesResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String nextUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String previousUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<ServiceResource> resources;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalPages;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalResults;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServicesResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesResponseBuilder nextUrl(final String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesResponseBuilder previousUrl(final String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesResponseBuilder resource(final ServiceResource resource) {
            if (this.resources == null) this.resources = new java.util.ArrayList<ServiceResource>();
            this.resources.add(resource);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesResponseBuilder resources(final java.util.Collection<? extends ServiceResource> resources) {
            if (this.resources == null) this.resources = new java.util.ArrayList<ServiceResource>();
            this.resources.addAll(resources);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesResponseBuilder totalPages(final Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesResponseBuilder totalResults(final Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServicesResponse build() {
            java.util.List<ServiceResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
            case 0: 
                resources = java.util.Collections.emptyList();
                break;
            
            case 1: 
                resources = java.util.Collections.singletonList(this.resources.get(0));
                break;
            
            default: 
                resources = java.util.Collections.unmodifiableList(new java.util.ArrayList<ServiceResource>(this.resources));
            
            }
            return new ListServicesResponse(nextUrl, previousUrl, resources, totalPages, totalResults);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServicesResponse.ListServicesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServicesResponseBuilder builder() {
        return new ListServicesResponseBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServicesResponse)) return false;
        final ListServicesResponse other = (ListServicesResponse)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServicesResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServicesResponse(super=" + super.toString() + ")";
    }
}