// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.services;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The entity response payload for Services
 */
public final class ServiceEntity {
    
    /**
     * The active status
     *
     * @param active service can be provisioned
     */
    private final Boolean active;
    
    /**
     * The bindable status
     *
     * @param bindable the service can be bound
     */
    private final Boolean bindable;
    
    /**
     * The description
     *
     * @param description the description
     */
    private final String description;
    
    /**
     * The documentation url
     *
     * @param documentationUrl the documentation url
     */
    private final String documentationUrl;
    
    /**
     * Extra service-related data
     *
     * @param extra the extra data
     */
    private final String extra;
    
    /**
     * The info url
     *
     * @param infoUrl the info url
     */
    private final String infoUrl;
    
    /**
     * The name of the service
     *
     * @param label the label
     */
    private final String label;
    
    /**
     * The long description
     *
     * @param longDescription the long description
     */
    private final String longDescription;
    
    /**
     * Whether the service can be updated to a different plan
     *
     * @param planUpdateable the plan updateable status
     */
    private final Boolean planUpdateable;
    
    /**
     * The name of the service provider
     *
     * @param provider the provider
     */
    private final String provider;
    
    /**
     * Required dependencies
     *
     * @param requires the required dependencies
     */
    private final List<String> requires;
    
    /**
     * The service broker id
     *
     * @param serviceBrokerId the service broker id
     */
    private final String serviceBrokerId;
    
    /**
     * The service plans url
     *
     * @param servicePlansUrl the service plans url
     */
    private final String servicePlansUrl;
    
    /**
     * The tags
     *
     * @param tags the tags
     */
    private final List<String> tags;
    
    /**
     * The unique id to identify the service with the broker
     *
     * @param uniqueId the unique id
     */
    private final String uniqueId;
    
    /**
     * The url
     *
     * @param url the url
     */
    private final String url;
    
    /**
     * The version
     *
     * @param version the version
     */
    private final String version;

    ServiceEntity(@JsonProperty("active") Boolean active, @JsonProperty("bindable") Boolean bindable, @JsonProperty("description") String description, @JsonProperty("documentation_url") @Deprecated String documentationUrl, @JsonProperty("extra") String extra, @JsonProperty("info_url") @Deprecated String infoUrl, @JsonProperty("label") String label, @JsonProperty("long_description") @Deprecated String longDescription, @JsonProperty("plan_updateable") Boolean planUpdateable, @JsonProperty("provider") @Deprecated String provider, @JsonProperty("requires") List<String> requires, @JsonProperty("service_broker_guid") String serviceBrokerId, @JsonProperty("service_plans_url") String servicePlansUrl, @JsonProperty("tags") List<String> tags, @JsonProperty("unique_id") String uniqueId, @JsonProperty("url") @Deprecated String url, @JsonProperty("version") @Deprecated String version) {
        this.active = active;
        this.bindable = bindable;
        this.description = description;
        this.documentationUrl = documentationUrl;
        this.extra = extra;
        this.infoUrl = infoUrl;
        this.label = label;
        this.longDescription = longDescription;
        this.planUpdateable = planUpdateable;
        this.provider = provider;
        this.requires = requires;
        this.serviceBrokerId = serviceBrokerId;
        this.servicePlansUrl = servicePlansUrl;
        this.tags = tags;
        this.uniqueId = uniqueId;
        this.url = url;
        this.version = version;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ServiceEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean active;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean bindable;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String description;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String documentationUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String extra;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String infoUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String label;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String longDescription;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean planUpdateable;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String provider;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> requires;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceBrokerId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String servicePlansUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> tags;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String uniqueId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String url;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String version;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ServiceEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder active(final Boolean active) {
            this.active = active;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder bindable(final Boolean bindable) {
            this.bindable = bindable;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder description(final String description) {
            this.description = description;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder documentationUrl(final String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder extra(final String extra) {
            this.extra = extra;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder infoUrl(final String infoUrl) {
            this.infoUrl = infoUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder label(final String label) {
            this.label = label;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder longDescription(final String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder planUpdateable(final Boolean planUpdateable) {
            this.planUpdateable = planUpdateable;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder provider(final String provider) {
            this.provider = provider;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder require(final String require) {
            if (this.requires == null) this.requires = new java.util.ArrayList<String>();
            this.requires.add(require);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder requires(final java.util.Collection<? extends String> requires) {
            if (this.requires == null) this.requires = new java.util.ArrayList<String>();
            this.requires.addAll(requires);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder serviceBrokerId(final String serviceBrokerId) {
            this.serviceBrokerId = serviceBrokerId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder servicePlansUrl(final String servicePlansUrl) {
            this.servicePlansUrl = servicePlansUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder tag(final String tag) {
            if (this.tags == null) this.tags = new java.util.ArrayList<String>();
            this.tags.add(tag);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder tags(final java.util.Collection<? extends String> tags) {
            if (this.tags == null) this.tags = new java.util.ArrayList<String>();
            this.tags.addAll(tags);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder uniqueId(final String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder url(final String url) {
            this.url = url;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntityBuilder version(final String version) {
            this.version = version;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ServiceEntity build() {
            java.util.List<String> requires;
            switch (this.requires == null ? 0 : this.requires.size()) {
            case 0: 
                requires = java.util.Collections.emptyList();
                break;
            
            case 1: 
                requires = java.util.Collections.singletonList(this.requires.get(0));
                break;
            
            default: 
                requires = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.requires));
            
            }
            java.util.List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
            case 0: 
                tags = java.util.Collections.emptyList();
                break;
            
            case 1: 
                tags = java.util.Collections.singletonList(this.tags.get(0));
                break;
            
            default: 
                tags = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.tags));
            
            }
            return new ServiceEntity(active, bindable, description, documentationUrl, extra, infoUrl, label, longDescription, planUpdateable, provider, requires, serviceBrokerId, servicePlansUrl, tags, uniqueId, url, version);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ServiceEntity.ServiceEntityBuilder(active=" + this.active + ", bindable=" + this.bindable + ", description=" + this.description + ", documentationUrl=" + this.documentationUrl + ", extra=" + this.extra + ", infoUrl=" + this.infoUrl + ", label=" + this.label + ", longDescription=" + this.longDescription + ", planUpdateable=" + this.planUpdateable + ", provider=" + this.provider + ", requires=" + this.requires + ", serviceBrokerId=" + this.serviceBrokerId + ", servicePlansUrl=" + this.servicePlansUrl + ", tags=" + this.tags + ", uniqueId=" + this.uniqueId + ", url=" + this.url + ", version=" + this.version + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ServiceEntityBuilder builder() {
        return new ServiceEntityBuilder();
    }

    /**
     * The active status
     *
     * @return active status
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getActive() {
        return this.active;
    }

    /**
     * The bindable status
     *
     * @return bindable status
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getBindable() {
        return this.bindable;
    }

    /**
     * The description
     *
     * @return the description
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDescription() {
        return this.description;
    }

    /**
     * Extra service-related data
     *
     * @return the extra data
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getExtra() {
        return this.extra;
    }

    /**
     * The name of the service
     *
     * @return the label
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getLabel() {
        return this.label;
    }

    /**
     * Whether the service can be updated to a different plan
     *
     * @return the plan updateable status
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getPlanUpdateable() {
        return this.planUpdateable;
    }

    /**
     * Required dependencies
     *
     * @return the required dependencies
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getRequires() {
        return this.requires;
    }

    /**
     * The service broker id
     *
     * @return the service broker id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceBrokerId() {
        return this.serviceBrokerId;
    }

    /**
     * The service plans url
     *
     * @return the service plans url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServicePlansUrl() {
        return this.servicePlansUrl;
    }

    /**
     * The tags
     *
     * @return the tags
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getTags() {
        return this.tags;
    }

    /**
     * The unique id to identify the service with the broker
     *
     * @return the unique id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUniqueId() {
        return this.uniqueId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServiceEntity)) return false;
        final ServiceEntity other = (ServiceEntity)o;
        final java.lang.Object this$active = this.getActive();
        final java.lang.Object other$active = other.getActive();
        if (this$active == null ? other$active != null : !this$active.equals(other$active)) return false;
        final java.lang.Object this$bindable = this.getBindable();
        final java.lang.Object other$bindable = other.getBindable();
        if (this$bindable == null ? other$bindable != null : !this$bindable.equals(other$bindable)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$documentationUrl = this.getDocumentationUrl();
        final java.lang.Object other$documentationUrl = other.getDocumentationUrl();
        if (this$documentationUrl == null ? other$documentationUrl != null : !this$documentationUrl.equals(other$documentationUrl)) return false;
        final java.lang.Object this$extra = this.getExtra();
        final java.lang.Object other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) return false;
        final java.lang.Object this$infoUrl = this.getInfoUrl();
        final java.lang.Object other$infoUrl = other.getInfoUrl();
        if (this$infoUrl == null ? other$infoUrl != null : !this$infoUrl.equals(other$infoUrl)) return false;
        final java.lang.Object this$label = this.getLabel();
        final java.lang.Object other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
        final java.lang.Object this$longDescription = this.getLongDescription();
        final java.lang.Object other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) return false;
        final java.lang.Object this$planUpdateable = this.getPlanUpdateable();
        final java.lang.Object other$planUpdateable = other.getPlanUpdateable();
        if (this$planUpdateable == null ? other$planUpdateable != null : !this$planUpdateable.equals(other$planUpdateable)) return false;
        final java.lang.Object this$provider = this.getProvider();
        final java.lang.Object other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) return false;
        final java.lang.Object this$requires = this.getRequires();
        final java.lang.Object other$requires = other.getRequires();
        if (this$requires == null ? other$requires != null : !this$requires.equals(other$requires)) return false;
        final java.lang.Object this$serviceBrokerId = this.getServiceBrokerId();
        final java.lang.Object other$serviceBrokerId = other.getServiceBrokerId();
        if (this$serviceBrokerId == null ? other$serviceBrokerId != null : !this$serviceBrokerId.equals(other$serviceBrokerId)) return false;
        final java.lang.Object this$servicePlansUrl = this.getServicePlansUrl();
        final java.lang.Object other$servicePlansUrl = other.getServicePlansUrl();
        if (this$servicePlansUrl == null ? other$servicePlansUrl != null : !this$servicePlansUrl.equals(other$servicePlansUrl)) return false;
        final java.lang.Object this$tags = this.getTags();
        final java.lang.Object other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) return false;
        final java.lang.Object this$uniqueId = this.getUniqueId();
        final java.lang.Object other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) return false;
        final java.lang.Object this$url = this.getUrl();
        final java.lang.Object other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $active = this.getActive();
        result = result * PRIME + ($active == null ? 43 : $active.hashCode());
        final java.lang.Object $bindable = this.getBindable();
        result = result * PRIME + ($bindable == null ? 43 : $bindable.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $documentationUrl = this.getDocumentationUrl();
        result = result * PRIME + ($documentationUrl == null ? 43 : $documentationUrl.hashCode());
        final java.lang.Object $extra = this.getExtra();
        result = result * PRIME + ($extra == null ? 43 : $extra.hashCode());
        final java.lang.Object $infoUrl = this.getInfoUrl();
        result = result * PRIME + ($infoUrl == null ? 43 : $infoUrl.hashCode());
        final java.lang.Object $label = this.getLabel();
        result = result * PRIME + ($label == null ? 43 : $label.hashCode());
        final java.lang.Object $longDescription = this.getLongDescription();
        result = result * PRIME + ($longDescription == null ? 43 : $longDescription.hashCode());
        final java.lang.Object $planUpdateable = this.getPlanUpdateable();
        result = result * PRIME + ($planUpdateable == null ? 43 : $planUpdateable.hashCode());
        final java.lang.Object $provider = this.getProvider();
        result = result * PRIME + ($provider == null ? 43 : $provider.hashCode());
        final java.lang.Object $requires = this.getRequires();
        result = result * PRIME + ($requires == null ? 43 : $requires.hashCode());
        final java.lang.Object $serviceBrokerId = this.getServiceBrokerId();
        result = result * PRIME + ($serviceBrokerId == null ? 43 : $serviceBrokerId.hashCode());
        final java.lang.Object $servicePlansUrl = this.getServicePlansUrl();
        result = result * PRIME + ($servicePlansUrl == null ? 43 : $servicePlansUrl.hashCode());
        final java.lang.Object $tags = this.getTags();
        result = result * PRIME + ($tags == null ? 43 : $tags.hashCode());
        final java.lang.Object $uniqueId = this.getUniqueId();
        result = result * PRIME + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        final java.lang.Object $url = this.getUrl();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ServiceEntity(active=" + this.getActive() + ", bindable=" + this.getBindable() + ", description=" + this.getDescription() + ", documentationUrl=" + this.getDocumentationUrl() + ", extra=" + this.getExtra() + ", infoUrl=" + this.getInfoUrl() + ", label=" + this.getLabel() + ", longDescription=" + this.getLongDescription() + ", planUpdateable=" + this.getPlanUpdateable() + ", provider=" + this.getProvider() + ", requires=" + this.getRequires() + ", serviceBrokerId=" + this.getServiceBrokerId() + ", servicePlansUrl=" + this.getServicePlansUrl() + ", tags=" + this.getTags() + ", uniqueId=" + this.getUniqueId() + ", url=" + this.getUrl() + ", version=" + this.getVersion() + ")";
    }

    /**
     * The documentation url
     *
     * @return the documentation url
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    /**
     * The info url
     *
     * @return the info url
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getInfoUrl() {
        return this.infoUrl;
    }

    /**
     * The long description
     *
     * @return the long description
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getLongDescription() {
        return this.longDescription;
    }

    /**
     * The name of the service provider
     *
     * @return the provider
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getProvider() {
        return this.provider;
    }

    /**
     * The url
     *
     * @return the url
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUrl() {
        return this.url;
    }

    /**
     * The version
     *
     * @return the version
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getVersion() {
        return this.version;
    }
}