// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceusageevents;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Get Service Usage Events operation
 */
public final class GetServiceUsageEventsRequest implements Validatable {
    
    /**
     * The service usage event id
     *
     * @param serviceUsageEventId the service usage event id
     */
    private final String serviceUsageEventId;

    GetServiceUsageEventsRequest(String serviceUsageEventId) {
        this.serviceUsageEventId = serviceUsageEventId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.serviceUsageEventId == null) {
            builder.message("service usage event id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetServiceUsageEventsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceUsageEventId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetServiceUsageEventsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServiceUsageEventsRequestBuilder serviceUsageEventId(final String serviceUsageEventId) {
            this.serviceUsageEventId = serviceUsageEventId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetServiceUsageEventsRequest build() {
            return new GetServiceUsageEventsRequest(serviceUsageEventId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetServiceUsageEventsRequest.GetServiceUsageEventsRequestBuilder(serviceUsageEventId=" + this.serviceUsageEventId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetServiceUsageEventsRequestBuilder builder() {
        return new GetServiceUsageEventsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetServiceUsageEventsRequest)) return false;
        final GetServiceUsageEventsRequest other = (GetServiceUsageEventsRequest)o;
        final java.lang.Object this$serviceUsageEventId = this.getServiceUsageEventId();
        final java.lang.Object other$serviceUsageEventId = other.getServiceUsageEventId();
        if (this$serviceUsageEventId == null ? other$serviceUsageEventId != null : !this$serviceUsageEventId.equals(other$serviceUsageEventId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $serviceUsageEventId = this.getServiceUsageEventId();
        result = result * PRIME + ($serviceUsageEventId == null ? 43 : $serviceUsageEventId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetServiceUsageEventsRequest(serviceUsageEventId=" + this.getServiceUsageEventId() + ")";
    }

    /**
     * The service usage event id
     *
     * @return the service usage event id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceUsageEventId() {
        return this.serviceUsageEventId;
    }
}