// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.serviceusageevents;

import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List Service Usage Events operation
 */
public final class ListServiceUsageEventsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The after service usage event id: Restrict results to Service Usage Events after the one with the given id
     *
     * @param afterServiceUsageEventId the after service usage event id
     */
    private final String afterServiceUsageEventId;
    
    /**
     * The service ids
     *
     * @param serviceIds the service ids
     */
    private final List<String> serviceIds;
    
    /**
     * The service instance types
     *
     * @param serviceInstanceTypes the service instance types
     */
    private final List<String> serviceInstanceTypes;

    ListServiceUsageEventsRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, String afterServiceUsageEventId, List<String> serviceIds, List<String> serviceInstanceTypes) {
        super(orderDirection, page, resultsPerPage);
        this.afterServiceUsageEventId = afterServiceUsageEventId;
        this.serviceIds = serviceIds;
        this.serviceInstanceTypes = serviceInstanceTypes;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListServiceUsageEventsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String afterServiceUsageEventId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceInstanceTypes;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListServiceUsageEventsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder afterServiceUsageEventId(final String afterServiceUsageEventId) {
            this.afterServiceUsageEventId = afterServiceUsageEventId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder serviceId(final String serviceId) {
            if (this.serviceIds == null) this.serviceIds = new java.util.ArrayList<String>();
            this.serviceIds.add(serviceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder serviceIds(final java.util.Collection<? extends String> serviceIds) {
            if (this.serviceIds == null) this.serviceIds = new java.util.ArrayList<String>();
            this.serviceIds.addAll(serviceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder serviceInstanceType(final String serviceInstanceType) {
            if (this.serviceInstanceTypes == null) this.serviceInstanceTypes = new java.util.ArrayList<String>();
            this.serviceInstanceTypes.add(serviceInstanceType);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequestBuilder serviceInstanceTypes(final java.util.Collection<? extends String> serviceInstanceTypes) {
            if (this.serviceInstanceTypes == null) this.serviceInstanceTypes = new java.util.ArrayList<String>();
            this.serviceInstanceTypes.addAll(serviceInstanceTypes);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListServiceUsageEventsRequest build() {
            java.util.List<String> serviceIds;
            switch (this.serviceIds == null ? 0 : this.serviceIds.size()) {
            case 0: 
                serviceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceIds = java.util.Collections.singletonList(this.serviceIds.get(0));
                break;
            
            default: 
                serviceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceIds));
            
            }
            java.util.List<String> serviceInstanceTypes;
            switch (this.serviceInstanceTypes == null ? 0 : this.serviceInstanceTypes.size()) {
            case 0: 
                serviceInstanceTypes = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceInstanceTypes = java.util.Collections.singletonList(this.serviceInstanceTypes.get(0));
                break;
            
            default: 
                serviceInstanceTypes = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceInstanceTypes));
            
            }
            return new ListServiceUsageEventsRequest(orderDirection, page, resultsPerPage, afterServiceUsageEventId, serviceIds, serviceInstanceTypes);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListServiceUsageEventsRequest.ListServiceUsageEventsRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", afterServiceUsageEventId=" + this.afterServiceUsageEventId + ", serviceIds=" + this.serviceIds + ", serviceInstanceTypes=" + this.serviceInstanceTypes + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListServiceUsageEventsRequestBuilder builder() {
        return new ListServiceUsageEventsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListServiceUsageEventsRequest)) return false;
        final ListServiceUsageEventsRequest other = (ListServiceUsageEventsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$afterServiceUsageEventId = this.getAfterServiceUsageEventId();
        final java.lang.Object other$afterServiceUsageEventId = other.getAfterServiceUsageEventId();
        if (this$afterServiceUsageEventId == null ? other$afterServiceUsageEventId != null : !this$afterServiceUsageEventId.equals(other$afterServiceUsageEventId)) return false;
        final java.lang.Object this$serviceIds = this.getServiceIds();
        final java.lang.Object other$serviceIds = other.getServiceIds();
        if (this$serviceIds == null ? other$serviceIds != null : !this$serviceIds.equals(other$serviceIds)) return false;
        final java.lang.Object this$serviceInstanceTypes = this.getServiceInstanceTypes();
        final java.lang.Object other$serviceInstanceTypes = other.getServiceInstanceTypes();
        if (this$serviceInstanceTypes == null ? other$serviceInstanceTypes != null : !this$serviceInstanceTypes.equals(other$serviceInstanceTypes)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListServiceUsageEventsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $afterServiceUsageEventId = this.getAfterServiceUsageEventId();
        result = result * PRIME + ($afterServiceUsageEventId == null ? 43 : $afterServiceUsageEventId.hashCode());
        final java.lang.Object $serviceIds = this.getServiceIds();
        result = result * PRIME + ($serviceIds == null ? 43 : $serviceIds.hashCode());
        final java.lang.Object $serviceInstanceTypes = this.getServiceInstanceTypes();
        result = result * PRIME + ($serviceInstanceTypes == null ? 43 : $serviceInstanceTypes.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListServiceUsageEventsRequest(super=" + super.toString() + ", afterServiceUsageEventId=" + this.getAfterServiceUsageEventId() + ", serviceIds=" + this.getServiceIds() + ", serviceInstanceTypes=" + this.getServiceInstanceTypes() + ")";
    }

    /**
     * The after service usage event id: Restrict results to Service Usage Events after the one with the given id
     *
     * @return the after service usage event id
     */
    @QueryParameter("after_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAfterServiceUsageEventId() {
        return this.afterServiceUsageEventId;
    }

    /**
     * The service ids
     *
     * @return the service ids
     */
    @InFilterParameter("service_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceIds() {
        return this.serviceIds;
    }

    /**
     * The service instance types
     *
     * @return the service instance types
     */
    @InFilterParameter("service_instance_type")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceInstanceTypes() {
        return this.serviceInstanceTypes;
    }
}