// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Retrieve a Particular Space Quota Definition operation
 */
public final class GetSpaceQuotaDefinitionRequest implements Validatable {
    
    /**
     * The space quota definition id
     *
     * @param spaceQuotaDefinitionId the space quota definition id
     */
    private final String spaceQuotaDefinitionId;

    GetSpaceQuotaDefinitionRequest(String spaceQuotaDefinitionId) {
        this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceQuotaDefinitionId == null) {
            builder.message("space quota definition id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetSpaceQuotaDefinitionRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceQuotaDefinitionId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetSpaceQuotaDefinitionRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceQuotaDefinitionRequestBuilder spaceQuotaDefinitionId(final String spaceQuotaDefinitionId) {
            this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceQuotaDefinitionRequest build() {
            return new GetSpaceQuotaDefinitionRequest(spaceQuotaDefinitionId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetSpaceQuotaDefinitionRequest.GetSpaceQuotaDefinitionRequestBuilder(spaceQuotaDefinitionId=" + this.spaceQuotaDefinitionId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetSpaceQuotaDefinitionRequestBuilder builder() {
        return new GetSpaceQuotaDefinitionRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetSpaceQuotaDefinitionRequest)) return false;
        final GetSpaceQuotaDefinitionRequest other = (GetSpaceQuotaDefinitionRequest)o;
        final java.lang.Object this$spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        final java.lang.Object other$spaceQuotaDefinitionId = other.getSpaceQuotaDefinitionId();
        if (this$spaceQuotaDefinitionId == null ? other$spaceQuotaDefinitionId != null : !this$spaceQuotaDefinitionId.equals(other$spaceQuotaDefinitionId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        result = result * PRIME + ($spaceQuotaDefinitionId == null ? 43 : $spaceQuotaDefinitionId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetSpaceQuotaDefinitionRequest(spaceQuotaDefinitionId=" + this.getSpaceQuotaDefinitionId() + ")";
    }

    /**
     * The space quota definition id
     *
     * @return the space quota definition id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceQuotaDefinitionId() {
        return this.spaceQuotaDefinitionId;
    }
}