// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Remove Space from the Space Quota Definition operation
 */
public final class RemoveSpaceQuotaDefinitionRequest implements Validatable {
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * The space quota definition id
     *
     * @param spaceQuotaDefinitionId the space quota definition id
     */
    private final String spaceQuotaDefinitionId;

    RemoveSpaceQuotaDefinitionRequest(String spaceId, String spaceQuotaDefinitionId) {
        this.spaceId = spaceId;
        this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        if (this.spaceQuotaDefinitionId == null) {
            builder.message("space quota definition id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RemoveSpaceQuotaDefinitionRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceQuotaDefinitionId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RemoveSpaceQuotaDefinitionRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceQuotaDefinitionRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceQuotaDefinitionRequestBuilder spaceQuotaDefinitionId(final String spaceQuotaDefinitionId) {
            this.spaceQuotaDefinitionId = spaceQuotaDefinitionId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceQuotaDefinitionRequest build() {
            return new RemoveSpaceQuotaDefinitionRequest(spaceId, spaceQuotaDefinitionId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RemoveSpaceQuotaDefinitionRequest.RemoveSpaceQuotaDefinitionRequestBuilder(spaceId=" + this.spaceId + ", spaceQuotaDefinitionId=" + this.spaceQuotaDefinitionId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RemoveSpaceQuotaDefinitionRequestBuilder builder() {
        return new RemoveSpaceQuotaDefinitionRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RemoveSpaceQuotaDefinitionRequest)) return false;
        final RemoveSpaceQuotaDefinitionRequest other = (RemoveSpaceQuotaDefinitionRequest)o;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        final java.lang.Object this$spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        final java.lang.Object other$spaceQuotaDefinitionId = other.getSpaceQuotaDefinitionId();
        if (this$spaceQuotaDefinitionId == null ? other$spaceQuotaDefinitionId != null : !this$spaceQuotaDefinitionId.equals(other$spaceQuotaDefinitionId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        final java.lang.Object $spaceQuotaDefinitionId = this.getSpaceQuotaDefinitionId();
        result = result * PRIME + ($spaceQuotaDefinitionId == null ? 43 : $spaceQuotaDefinitionId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RemoveSpaceQuotaDefinitionRequest(spaceId=" + this.getSpaceId() + ", spaceQuotaDefinitionId=" + this.getSpaceQuotaDefinitionId() + ")";
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The space quota definition id
     *
     * @return the space quota definition id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceQuotaDefinitionId() {
        return this.spaceQuotaDefinitionId;
    }
}