// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The entity response payload for the Space Quota Definition resource
 */
public final class SpaceQuotaDefinitionEntity {
    
    /**
     * The application instance limit
     *
     * @param applicationInstanceLimit the application instance limit
     */
    private final Integer applicationInstanceLimit;
    
    /**
     * The instance memory limit
     *
     * @param instanceMemoryLimit the instance memory limit
     */
    private final Integer instanceMemoryLimit;
    
    /**
     * The memory limit
     *
     * @param memoryLimit the memory limit
     */
    private final Integer memoryLimit;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The non basic services allowed
     *
     * @param nonBasicServicesAllowed the non basic services allowed boolean
     */
    private final Boolean nonBasicServicesAllowed;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;
    
    /**
     * The organization url
     *
     * @param organizationUrl the organization url
     */
    private final String organizationUrl;
    
    /**
     * The spaces url
     *
     * @param spacesUrl the spaces url
     */
    private final String spacesUrl;
    
    /**
     * The total routes
     *
     * @param totalRoutes the total routes
     */
    private final Integer totalRoutes;
    
    /**
     * The total services
     *
     * @param totalServices the total services
     */
    private final Integer totalServices;

    SpaceQuotaDefinitionEntity(@JsonProperty("app_instance_limit") Integer applicationInstanceLimit, @JsonProperty("instance_memory_limit") Integer instanceMemoryLimit, @JsonProperty("memory_limit") Integer memoryLimit, @JsonProperty("name") String name, @JsonProperty("non_basic_services_allowed") Boolean nonBasicServicesAllowed, @JsonProperty("organization_guid") String organizationId, @JsonProperty("organization_url") String organizationUrl, @JsonProperty("spaces_url") String spacesUrl, @JsonProperty("total_routes") Integer totalRoutes, @JsonProperty("total_services") Integer totalServices) {
        this.applicationInstanceLimit = applicationInstanceLimit;
        this.instanceMemoryLimit = instanceMemoryLimit;
        this.memoryLimit = memoryLimit;
        this.name = name;
        this.nonBasicServicesAllowed = nonBasicServicesAllowed;
        this.organizationId = organizationId;
        this.organizationUrl = organizationUrl;
        this.spacesUrl = spacesUrl;
        this.totalRoutes = totalRoutes;
        this.totalServices = totalServices;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class SpaceQuotaDefinitionEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer applicationInstanceLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer instanceMemoryLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memoryLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean nonBasicServicesAllowed;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spacesUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalRoutes;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalServices;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        SpaceQuotaDefinitionEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder applicationInstanceLimit(final Integer applicationInstanceLimit) {
            this.applicationInstanceLimit = applicationInstanceLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder instanceMemoryLimit(final Integer instanceMemoryLimit) {
            this.instanceMemoryLimit = instanceMemoryLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder memoryLimit(final Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder nonBasicServicesAllowed(final Boolean nonBasicServicesAllowed) {
            this.nonBasicServicesAllowed = nonBasicServicesAllowed;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder organizationUrl(final String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder spacesUrl(final String spacesUrl) {
            this.spacesUrl = spacesUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder totalRoutes(final Integer totalRoutes) {
            this.totalRoutes = totalRoutes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntityBuilder totalServices(final Integer totalServices) {
            this.totalServices = totalServices;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SpaceQuotaDefinitionEntity build() {
            return new SpaceQuotaDefinitionEntity(applicationInstanceLimit, instanceMemoryLimit, memoryLimit, name, nonBasicServicesAllowed, organizationId, organizationUrl, spacesUrl, totalRoutes, totalServices);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "SpaceQuotaDefinitionEntity.SpaceQuotaDefinitionEntityBuilder(applicationInstanceLimit=" + this.applicationInstanceLimit + ", instanceMemoryLimit=" + this.instanceMemoryLimit + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", nonBasicServicesAllowed=" + this.nonBasicServicesAllowed + ", organizationId=" + this.organizationId + ", organizationUrl=" + this.organizationUrl + ", spacesUrl=" + this.spacesUrl + ", totalRoutes=" + this.totalRoutes + ", totalServices=" + this.totalServices + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static SpaceQuotaDefinitionEntityBuilder builder() {
        return new SpaceQuotaDefinitionEntityBuilder();
    }

    /**
     * The application instance limit
     *
     * @return applicationInstanceLimit
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getApplicationInstanceLimit() {
        return this.applicationInstanceLimit;
    }

    /**
     * The instance memory limit
     *
     * @return instanceMemoryLimit
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getInstanceMemoryLimit() {
        return this.instanceMemoryLimit;
    }

    /**
     * The memory limit
     *
     * @return memory limit
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    /**
     * The name
     *
     * @return name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The non basic services allowed
     *
     * @return the nonBasicServicesAllowed
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getNonBasicServicesAllowed() {
        return this.nonBasicServicesAllowed;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * The organization url
     *
     * @return the organization url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    /**
     * The spaces url
     *
     * @return the spaces url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpacesUrl() {
        return this.spacesUrl;
    }

    /**
     * The total routes
     *
     * @return the total routes
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalRoutes() {
        return this.totalRoutes;
    }

    /**
     * The total services
     *
     * @return the total services
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalServices() {
        return this.totalServices;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SpaceQuotaDefinitionEntity)) return false;
        final SpaceQuotaDefinitionEntity other = (SpaceQuotaDefinitionEntity)o;
        final java.lang.Object this$applicationInstanceLimit = this.getApplicationInstanceLimit();
        final java.lang.Object other$applicationInstanceLimit = other.getApplicationInstanceLimit();
        if (this$applicationInstanceLimit == null ? other$applicationInstanceLimit != null : !this$applicationInstanceLimit.equals(other$applicationInstanceLimit)) return false;
        final java.lang.Object this$instanceMemoryLimit = this.getInstanceMemoryLimit();
        final java.lang.Object other$instanceMemoryLimit = other.getInstanceMemoryLimit();
        if (this$instanceMemoryLimit == null ? other$instanceMemoryLimit != null : !this$instanceMemoryLimit.equals(other$instanceMemoryLimit)) return false;
        final java.lang.Object this$memoryLimit = this.getMemoryLimit();
        final java.lang.Object other$memoryLimit = other.getMemoryLimit();
        if (this$memoryLimit == null ? other$memoryLimit != null : !this$memoryLimit.equals(other$memoryLimit)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$nonBasicServicesAllowed = this.getNonBasicServicesAllowed();
        final java.lang.Object other$nonBasicServicesAllowed = other.getNonBasicServicesAllowed();
        if (this$nonBasicServicesAllowed == null ? other$nonBasicServicesAllowed != null : !this$nonBasicServicesAllowed.equals(other$nonBasicServicesAllowed)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        final java.lang.Object this$organizationUrl = this.getOrganizationUrl();
        final java.lang.Object other$organizationUrl = other.getOrganizationUrl();
        if (this$organizationUrl == null ? other$organizationUrl != null : !this$organizationUrl.equals(other$organizationUrl)) return false;
        final java.lang.Object this$spacesUrl = this.getSpacesUrl();
        final java.lang.Object other$spacesUrl = other.getSpacesUrl();
        if (this$spacesUrl == null ? other$spacesUrl != null : !this$spacesUrl.equals(other$spacesUrl)) return false;
        final java.lang.Object this$totalRoutes = this.getTotalRoutes();
        final java.lang.Object other$totalRoutes = other.getTotalRoutes();
        if (this$totalRoutes == null ? other$totalRoutes != null : !this$totalRoutes.equals(other$totalRoutes)) return false;
        final java.lang.Object this$totalServices = this.getTotalServices();
        final java.lang.Object other$totalServices = other.getTotalServices();
        if (this$totalServices == null ? other$totalServices != null : !this$totalServices.equals(other$totalServices)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationInstanceLimit = this.getApplicationInstanceLimit();
        result = result * PRIME + ($applicationInstanceLimit == null ? 43 : $applicationInstanceLimit.hashCode());
        final java.lang.Object $instanceMemoryLimit = this.getInstanceMemoryLimit();
        result = result * PRIME + ($instanceMemoryLimit == null ? 43 : $instanceMemoryLimit.hashCode());
        final java.lang.Object $memoryLimit = this.getMemoryLimit();
        result = result * PRIME + ($memoryLimit == null ? 43 : $memoryLimit.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $nonBasicServicesAllowed = this.getNonBasicServicesAllowed();
        result = result * PRIME + ($nonBasicServicesAllowed == null ? 43 : $nonBasicServicesAllowed.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        final java.lang.Object $organizationUrl = this.getOrganizationUrl();
        result = result * PRIME + ($organizationUrl == null ? 43 : $organizationUrl.hashCode());
        final java.lang.Object $spacesUrl = this.getSpacesUrl();
        result = result * PRIME + ($spacesUrl == null ? 43 : $spacesUrl.hashCode());
        final java.lang.Object $totalRoutes = this.getTotalRoutes();
        result = result * PRIME + ($totalRoutes == null ? 43 : $totalRoutes.hashCode());
        final java.lang.Object $totalServices = this.getTotalServices();
        result = result * PRIME + ($totalServices == null ? 43 : $totalServices.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "SpaceQuotaDefinitionEntity(applicationInstanceLimit=" + this.getApplicationInstanceLimit() + ", instanceMemoryLimit=" + this.getInstanceMemoryLimit() + ", memoryLimit=" + this.getMemoryLimit() + ", name=" + this.getName() + ", nonBasicServicesAllowed=" + this.getNonBasicServicesAllowed() + ", organizationId=" + this.getOrganizationId() + ", organizationUrl=" + this.getOrganizationUrl() + ", spacesUrl=" + this.getSpacesUrl() + ", totalRoutes=" + this.getTotalRoutes() + ", totalServices=" + this.getTotalServices() + ")";
    }
}