// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Associate Developer with the Space operation
 */
public final class AssociateSpaceDeveloperRequest implements Validatable {
    
    /**
     * The developer id
     *
     * @param developerId the developer id
     */
    private final String developerId;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    AssociateSpaceDeveloperRequest(String developerId, String spaceId) {
        this.developerId = developerId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.developerId == null) {
            builder.message("developer id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class AssociateSpaceDeveloperRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String developerId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        AssociateSpaceDeveloperRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateSpaceDeveloperRequestBuilder developerId(final String developerId) {
            this.developerId = developerId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateSpaceDeveloperRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateSpaceDeveloperRequest build() {
            return new AssociateSpaceDeveloperRequest(developerId, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "AssociateSpaceDeveloperRequest.AssociateSpaceDeveloperRequestBuilder(developerId=" + this.developerId + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static AssociateSpaceDeveloperRequestBuilder builder() {
        return new AssociateSpaceDeveloperRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AssociateSpaceDeveloperRequest)) return false;
        final AssociateSpaceDeveloperRequest other = (AssociateSpaceDeveloperRequest)o;
        final java.lang.Object this$developerId = this.getDeveloperId();
        final java.lang.Object other$developerId = other.getDeveloperId();
        if (this$developerId == null ? other$developerId != null : !this$developerId.equals(other$developerId)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $developerId = this.getDeveloperId();
        result = result * PRIME + ($developerId == null ? 43 : $developerId.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "AssociateSpaceDeveloperRequest(developerId=" + this.getDeveloperId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    /**
     * The developer id
     *
     * @return the developer id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDeveloperId() {
        return this.developerId;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}