// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstance;
import java.util.List;

/**
 * The response payload for the Get Space summary operation
 */
public final class GetSpaceSummaryResponse {
    private final List<SpaceApplicationSummary> applications;
    private final String id;
    private final String name;
    private final List<ServiceInstance> services;

    GetSpaceSummaryResponse(@JsonProperty("apps") List<SpaceApplicationSummary> applications, @JsonProperty("guid") String id, @JsonProperty("name") String name, @JsonProperty("services") List<ServiceInstance> services) {
        this.applications = applications;
        this.id = id;
        this.name = name;
        this.services = services;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetSpaceSummaryResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<SpaceApplicationSummary> applications;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String id;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<ServiceInstance> services;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetSpaceSummaryResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceSummaryResponseBuilder application(final SpaceApplicationSummary application) {
            if (this.applications == null) this.applications = new java.util.ArrayList<SpaceApplicationSummary>();
            this.applications.add(application);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceSummaryResponseBuilder applications(final java.util.Collection<? extends SpaceApplicationSummary> applications) {
            if (this.applications == null) this.applications = new java.util.ArrayList<SpaceApplicationSummary>();
            this.applications.addAll(applications);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceSummaryResponseBuilder id(final String id) {
            this.id = id;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceSummaryResponseBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceSummaryResponseBuilder service(final ServiceInstance service) {
            if (this.services == null) this.services = new java.util.ArrayList<ServiceInstance>();
            this.services.add(service);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceSummaryResponseBuilder services(final java.util.Collection<? extends ServiceInstance> services) {
            if (this.services == null) this.services = new java.util.ArrayList<ServiceInstance>();
            this.services.addAll(services);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetSpaceSummaryResponse build() {
            java.util.List<SpaceApplicationSummary> applications;
            switch (this.applications == null ? 0 : this.applications.size()) {
            case 0: 
                applications = java.util.Collections.emptyList();
                break;
            
            case 1: 
                applications = java.util.Collections.singletonList(this.applications.get(0));
                break;
            
            default: 
                applications = java.util.Collections.unmodifiableList(new java.util.ArrayList<SpaceApplicationSummary>(this.applications));
            
            }
            java.util.List<ServiceInstance> services;
            switch (this.services == null ? 0 : this.services.size()) {
            case 0: 
                services = java.util.Collections.emptyList();
                break;
            
            case 1: 
                services = java.util.Collections.singletonList(this.services.get(0));
                break;
            
            default: 
                services = java.util.Collections.unmodifiableList(new java.util.ArrayList<ServiceInstance>(this.services));
            
            }
            return new GetSpaceSummaryResponse(applications, id, name, services);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetSpaceSummaryResponse.GetSpaceSummaryResponseBuilder(applications=" + this.applications + ", id=" + this.id + ", name=" + this.name + ", services=" + this.services + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetSpaceSummaryResponseBuilder builder() {
        return new GetSpaceSummaryResponseBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<SpaceApplicationSummary> getApplications() {
        return this.applications;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<ServiceInstance> getServices() {
        return this.services;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetSpaceSummaryResponse)) return false;
        final GetSpaceSummaryResponse other = (GetSpaceSummaryResponse)o;
        final java.lang.Object this$applications = this.getApplications();
        final java.lang.Object other$applications = other.getApplications();
        if (this$applications == null ? other$applications != null : !this$applications.equals(other$applications)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$services = this.getServices();
        final java.lang.Object other$services = other.getServices();
        if (this$services == null ? other$services != null : !this$services.equals(other$services)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applications = this.getApplications();
        result = result * PRIME + ($applications == null ? 43 : $applications.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $services = this.getServices();
        result = result * PRIME + ($services == null ? 43 : $services.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetSpaceSummaryResponse(applications=" + this.getApplications() + ", id=" + this.getId() + ", name=" + this.getName() + ", services=" + this.getServices() + ")";
    }
}