// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.events.EventResource;
import java.util.List;

/**
 * The response payload for the List all Events for the Space operation
 */
public final class ListSpaceEventsResponse extends PaginatedResponse<EventResource> {

    ListSpaceEventsResponse(@JsonProperty("next_url") String nextUrl, @JsonProperty("prev_url") String previousUrl, @JsonProperty("resources") List<EventResource> resources, @JsonProperty("total_pages") Integer totalPages, @JsonProperty("total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListSpaceEventsResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String nextUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String previousUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<EventResource> resources;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalPages;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalResults;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListSpaceEventsResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceEventsResponseBuilder nextUrl(final String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceEventsResponseBuilder previousUrl(final String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceEventsResponseBuilder resource(final EventResource resource) {
            if (this.resources == null) this.resources = new java.util.ArrayList<EventResource>();
            this.resources.add(resource);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceEventsResponseBuilder resources(final java.util.Collection<? extends EventResource> resources) {
            if (this.resources == null) this.resources = new java.util.ArrayList<EventResource>();
            this.resources.addAll(resources);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceEventsResponseBuilder totalPages(final Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceEventsResponseBuilder totalResults(final Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceEventsResponse build() {
            java.util.List<EventResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
            case 0: 
                resources = java.util.Collections.emptyList();
                break;
            
            case 1: 
                resources = java.util.Collections.singletonList(this.resources.get(0));
                break;
            
            default: 
                resources = java.util.Collections.unmodifiableList(new java.util.ArrayList<EventResource>(this.resources));
            
            }
            return new ListSpaceEventsResponse(nextUrl, previousUrl, resources, totalPages, totalResults);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListSpaceEventsResponse.ListSpaceEventsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListSpaceEventsResponseBuilder builder() {
        return new ListSpaceEventsResponseBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListSpaceEventsResponse)) return false;
        final ListSpaceEventsResponse other = (ListSpaceEventsResponse)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListSpaceEventsResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListSpaceEventsResponse(super=" + super.toString() + ")";
    }
}