// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Routes for the Space operation
 */
public final class ListSpaceRoutesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The domain ids
     *
     * @param domainIds the domain ids
     */
    private final List<String> domainIds;
    
    /**
     * The hosts
     *
     * @param hosts the hosts
     */
    private final List<String> hosts;
    
    /**
     * The paths
     *
     * @param paths the paths
     */
    private final List<String> paths;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    ListSpaceRoutesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> domainIds, List<String> hosts, List<String> paths, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.domainIds = domainIds;
        this.hosts = hosts;
        this.paths = paths;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListSpaceRoutesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> domainIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> hosts;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> paths;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListSpaceRoutesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder domainId(final String domainId) {
            if (this.domainIds == null) this.domainIds = new java.util.ArrayList<String>();
            this.domainIds.add(domainId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder domainIds(final java.util.Collection<? extends String> domainIds) {
            if (this.domainIds == null) this.domainIds = new java.util.ArrayList<String>();
            this.domainIds.addAll(domainIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder host(final String host) {
            if (this.hosts == null) this.hosts = new java.util.ArrayList<String>();
            this.hosts.add(host);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder hosts(final java.util.Collection<? extends String> hosts) {
            if (this.hosts == null) this.hosts = new java.util.ArrayList<String>();
            this.hosts.addAll(hosts);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder path(final String path) {
            if (this.paths == null) this.paths = new java.util.ArrayList<String>();
            this.paths.add(path);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder paths(final java.util.Collection<? extends String> paths) {
            if (this.paths == null) this.paths = new java.util.ArrayList<String>();
            this.paths.addAll(paths);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceRoutesRequest build() {
            java.util.List<String> domainIds;
            switch (this.domainIds == null ? 0 : this.domainIds.size()) {
            case 0: 
                domainIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                domainIds = java.util.Collections.singletonList(this.domainIds.get(0));
                break;
            
            default: 
                domainIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.domainIds));
            
            }
            java.util.List<String> hosts;
            switch (this.hosts == null ? 0 : this.hosts.size()) {
            case 0: 
                hosts = java.util.Collections.emptyList();
                break;
            
            case 1: 
                hosts = java.util.Collections.singletonList(this.hosts.get(0));
                break;
            
            default: 
                hosts = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.hosts));
            
            }
            java.util.List<String> paths;
            switch (this.paths == null ? 0 : this.paths.size()) {
            case 0: 
                paths = java.util.Collections.emptyList();
                break;
            
            case 1: 
                paths = java.util.Collections.singletonList(this.paths.get(0));
                break;
            
            default: 
                paths = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.paths));
            
            }
            return new ListSpaceRoutesRequest(orderDirection, page, resultsPerPage, domainIds, hosts, paths, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListSpaceRoutesRequest.ListSpaceRoutesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", paths=" + this.paths + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListSpaceRoutesRequestBuilder builder() {
        return new ListSpaceRoutesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListSpaceRoutesRequest)) return false;
        final ListSpaceRoutesRequest other = (ListSpaceRoutesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$domainIds = this.getDomainIds();
        final java.lang.Object other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !this$domainIds.equals(other$domainIds)) return false;
        final java.lang.Object this$hosts = this.getHosts();
        final java.lang.Object other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) return false;
        final java.lang.Object this$paths = this.getPaths();
        final java.lang.Object other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !this$paths.equals(other$paths)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListSpaceRoutesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $domainIds = this.getDomainIds();
        result = result * PRIME + ($domainIds == null ? 43 : $domainIds.hashCode());
        final java.lang.Object $hosts = this.getHosts();
        result = result * PRIME + ($hosts == null ? 43 : $hosts.hashCode());
        final java.lang.Object $paths = this.getPaths();
        result = result * PRIME + ($paths == null ? 43 : $paths.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListSpaceRoutesRequest(super=" + super.toString() + ", domainIds=" + this.getDomainIds() + ", hosts=" + this.getHosts() + ", paths=" + this.getPaths() + ", spaceId=" + this.getSpaceId() + ")";
    }

    /**
     * The domain ids
     *
     * @return the domain ids
     */
    @InFilterParameter("domain_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    /**
     * The hosts
     *
     * @return the hosts
     */
    @InFilterParameter("host")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getHosts() {
        return this.hosts;
    }

    /**
     * The paths
     *
     * @return the paths
     */
    @InFilterParameter("path")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getPaths() {
        return this.paths;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}