// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service Instances for the Space operation
 */
public final class ListSpaceServiceInstancesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The gateway names
     *
     * @param gatewayNames the gateway names
     */
    private final List<String> gatewayNames;
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The organization ids
     *
     * @param organizationIds the organization ids
     */
    private final List<String> organizationIds;
    
    /**
     * The return user provided service instances
     *
     * @param returnUserProvidedServiceInstances the return user provided service instances
     */
    private final Boolean returnUserProvidedServiceInstances;
    
    /**
     * The service binding ids
     *
     * @param serviceBindingIds the service binding ids
     */
    private final List<String> serviceBindingIds;
    
    /**
     * The service key ids
     *
     * @param serviceKeyIds the service key ids
     */
    private final List<String> serviceKeyIds;
    
    /**
     * The service plan ids
     *
     * @param servicePlanIds the service plan ids
     */
    private final List<String> servicePlanIds;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    ListSpaceServiceInstancesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> gatewayNames, List<String> names, List<String> organizationIds, Boolean returnUserProvidedServiceInstances, List<String> serviceBindingIds, List<String> serviceKeyIds, List<String> servicePlanIds, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.gatewayNames = gatewayNames;
        this.names = names;
        this.organizationIds = organizationIds;
        this.returnUserProvidedServiceInstances = returnUserProvidedServiceInstances;
        this.serviceBindingIds = serviceBindingIds;
        this.serviceKeyIds = serviceKeyIds;
        this.servicePlanIds = servicePlanIds;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListSpaceServiceInstancesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> gatewayNames;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> organizationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean returnUserProvidedServiceInstances;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceBindingIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceKeyIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> servicePlanIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListSpaceServiceInstancesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder gatewayName(final String gatewayName) {
            if (this.gatewayNames == null) this.gatewayNames = new java.util.ArrayList<String>();
            this.gatewayNames.add(gatewayName);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder gatewayNames(final java.util.Collection<? extends String> gatewayNames) {
            if (this.gatewayNames == null) this.gatewayNames = new java.util.ArrayList<String>();
            this.gatewayNames.addAll(gatewayNames);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder organizationId(final String organizationId) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.add(organizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder organizationIds(final java.util.Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder returnUserProvidedServiceInstances(final Boolean returnUserProvidedServiceInstances) {
            this.returnUserProvidedServiceInstances = returnUserProvidedServiceInstances;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder serviceBindingId(final String serviceBindingId) {
            if (this.serviceBindingIds == null) this.serviceBindingIds = new java.util.ArrayList<String>();
            this.serviceBindingIds.add(serviceBindingId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder serviceBindingIds(final java.util.Collection<? extends String> serviceBindingIds) {
            if (this.serviceBindingIds == null) this.serviceBindingIds = new java.util.ArrayList<String>();
            this.serviceBindingIds.addAll(serviceBindingIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder serviceKeyId(final String serviceKeyId) {
            if (this.serviceKeyIds == null) this.serviceKeyIds = new java.util.ArrayList<String>();
            this.serviceKeyIds.add(serviceKeyId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder serviceKeyIds(final java.util.Collection<? extends String> serviceKeyIds) {
            if (this.serviceKeyIds == null) this.serviceKeyIds = new java.util.ArrayList<String>();
            this.serviceKeyIds.addAll(serviceKeyIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder servicePlanId(final String servicePlanId) {
            if (this.servicePlanIds == null) this.servicePlanIds = new java.util.ArrayList<String>();
            this.servicePlanIds.add(servicePlanId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder servicePlanIds(final java.util.Collection<? extends String> servicePlanIds) {
            if (this.servicePlanIds == null) this.servicePlanIds = new java.util.ArrayList<String>();
            this.servicePlanIds.addAll(servicePlanIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListSpaceServiceInstancesRequest build() {
            java.util.List<String> gatewayNames;
            switch (this.gatewayNames == null ? 0 : this.gatewayNames.size()) {
            case 0: 
                gatewayNames = java.util.Collections.emptyList();
                break;
            
            case 1: 
                gatewayNames = java.util.Collections.singletonList(this.gatewayNames.get(0));
                break;
            
            default: 
                gatewayNames = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.gatewayNames));
            
            }
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            java.util.List<String> organizationIds;
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
            case 0: 
                organizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                organizationIds = java.util.Collections.singletonList(this.organizationIds.get(0));
                break;
            
            default: 
                organizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.organizationIds));
            
            }
            java.util.List<String> serviceBindingIds;
            switch (this.serviceBindingIds == null ? 0 : this.serviceBindingIds.size()) {
            case 0: 
                serviceBindingIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceBindingIds = java.util.Collections.singletonList(this.serviceBindingIds.get(0));
                break;
            
            default: 
                serviceBindingIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceBindingIds));
            
            }
            java.util.List<String> serviceKeyIds;
            switch (this.serviceKeyIds == null ? 0 : this.serviceKeyIds.size()) {
            case 0: 
                serviceKeyIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceKeyIds = java.util.Collections.singletonList(this.serviceKeyIds.get(0));
                break;
            
            default: 
                serviceKeyIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceKeyIds));
            
            }
            java.util.List<String> servicePlanIds;
            switch (this.servicePlanIds == null ? 0 : this.servicePlanIds.size()) {
            case 0: 
                servicePlanIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                servicePlanIds = java.util.Collections.singletonList(this.servicePlanIds.get(0));
                break;
            
            default: 
                servicePlanIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.servicePlanIds));
            
            }
            return new ListSpaceServiceInstancesRequest(orderDirection, page, resultsPerPage, gatewayNames, names, organizationIds, returnUserProvidedServiceInstances, serviceBindingIds, serviceKeyIds, servicePlanIds, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListSpaceServiceInstancesRequest.ListSpaceServiceInstancesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", gatewayNames=" + this.gatewayNames + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", returnUserProvidedServiceInstances=" + this.returnUserProvidedServiceInstances + ", serviceBindingIds=" + this.serviceBindingIds + ", serviceKeyIds=" + this.serviceKeyIds + ", servicePlanIds=" + this.servicePlanIds + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListSpaceServiceInstancesRequestBuilder builder() {
        return new ListSpaceServiceInstancesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListSpaceServiceInstancesRequest)) return false;
        final ListSpaceServiceInstancesRequest other = (ListSpaceServiceInstancesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$gatewayNames = this.getGatewayNames();
        final java.lang.Object other$gatewayNames = other.getGatewayNames();
        if (this$gatewayNames == null ? other$gatewayNames != null : !this$gatewayNames.equals(other$gatewayNames)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$organizationIds = this.getOrganizationIds();
        final java.lang.Object other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !this$organizationIds.equals(other$organizationIds)) return false;
        final java.lang.Object this$returnUserProvidedServiceInstances = this.getReturnUserProvidedServiceInstances();
        final java.lang.Object other$returnUserProvidedServiceInstances = other.getReturnUserProvidedServiceInstances();
        if (this$returnUserProvidedServiceInstances == null ? other$returnUserProvidedServiceInstances != null : !this$returnUserProvidedServiceInstances.equals(other$returnUserProvidedServiceInstances)) return false;
        final java.lang.Object this$serviceBindingIds = this.getServiceBindingIds();
        final java.lang.Object other$serviceBindingIds = other.getServiceBindingIds();
        if (this$serviceBindingIds == null ? other$serviceBindingIds != null : !this$serviceBindingIds.equals(other$serviceBindingIds)) return false;
        final java.lang.Object this$serviceKeyIds = this.getServiceKeyIds();
        final java.lang.Object other$serviceKeyIds = other.getServiceKeyIds();
        if (this$serviceKeyIds == null ? other$serviceKeyIds != null : !this$serviceKeyIds.equals(other$serviceKeyIds)) return false;
        final java.lang.Object this$servicePlanIds = this.getServicePlanIds();
        final java.lang.Object other$servicePlanIds = other.getServicePlanIds();
        if (this$servicePlanIds == null ? other$servicePlanIds != null : !this$servicePlanIds.equals(other$servicePlanIds)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListSpaceServiceInstancesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $gatewayNames = this.getGatewayNames();
        result = result * PRIME + ($gatewayNames == null ? 43 : $gatewayNames.hashCode());
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $organizationIds = this.getOrganizationIds();
        result = result * PRIME + ($organizationIds == null ? 43 : $organizationIds.hashCode());
        final java.lang.Object $returnUserProvidedServiceInstances = this.getReturnUserProvidedServiceInstances();
        result = result * PRIME + ($returnUserProvidedServiceInstances == null ? 43 : $returnUserProvidedServiceInstances.hashCode());
        final java.lang.Object $serviceBindingIds = this.getServiceBindingIds();
        result = result * PRIME + ($serviceBindingIds == null ? 43 : $serviceBindingIds.hashCode());
        final java.lang.Object $serviceKeyIds = this.getServiceKeyIds();
        result = result * PRIME + ($serviceKeyIds == null ? 43 : $serviceKeyIds.hashCode());
        final java.lang.Object $servicePlanIds = this.getServicePlanIds();
        result = result * PRIME + ($servicePlanIds == null ? 43 : $servicePlanIds.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListSpaceServiceInstancesRequest(super=" + super.toString() + ", gatewayNames=" + this.getGatewayNames() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", returnUserProvidedServiceInstances=" + this.getReturnUserProvidedServiceInstances() + ", serviceBindingIds=" + this.getServiceBindingIds() + ", serviceKeyIds=" + this.getServiceKeyIds() + ", servicePlanIds=" + this.getServicePlanIds() + ", spaceId=" + this.getSpaceId() + ")";
    }

    /**
     * The gateway names
     *
     * @return the gateway names
     */
    @InFilterParameter("gateway_name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getGatewayNames() {
        return this.gatewayNames;
    }

    /**
     * The names
     *
     * @return the names
     */
    @InFilterParameter("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The organization ids
     *
     * @return the organization ids
     */
    @InFilterParameter("organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    /**
     * The return user provided service instances
     *
     * @return the return user provided service instances
     */
    @JsonProperty("return_user_provided_service_instances")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getReturnUserProvidedServiceInstances() {
        return this.returnUserProvidedServiceInstances;
    }

    /**
     * The service binding ids
     *
     * @return the service binding ids
     */
    @InFilterParameter("service_binding_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceBindingIds() {
        return this.serviceBindingIds;
    }

    /**
     * The service key ids
     *
     * @return the service key ids
     */
    @InFilterParameter("service_key_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceKeyIds() {
        return this.serviceKeyIds;
    }

    /**
     * The service plan ids
     *
     * @return the service plan ids
     */
    @InFilterParameter("service_plan_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}