// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Remove Auditor from the Space operation
 */
public final class RemoveSpaceAuditorRequest implements Validatable {
    
    /**
     * The auditor id
     *
     * @param auditorId the auditor id
     */
    private final String auditorId;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    RemoveSpaceAuditorRequest(String auditorId, String spaceId) {
        this.auditorId = auditorId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.auditorId == null) {
            builder.message("auditor id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RemoveSpaceAuditorRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String auditorId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RemoveSpaceAuditorRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceAuditorRequestBuilder auditorId(final String auditorId) {
            this.auditorId = auditorId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceAuditorRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceAuditorRequest build() {
            return new RemoveSpaceAuditorRequest(auditorId, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RemoveSpaceAuditorRequest.RemoveSpaceAuditorRequestBuilder(auditorId=" + this.auditorId + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RemoveSpaceAuditorRequestBuilder builder() {
        return new RemoveSpaceAuditorRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RemoveSpaceAuditorRequest)) return false;
        final RemoveSpaceAuditorRequest other = (RemoveSpaceAuditorRequest)o;
        final java.lang.Object this$auditorId = this.getAuditorId();
        final java.lang.Object other$auditorId = other.getAuditorId();
        if (this$auditorId == null ? other$auditorId != null : !this$auditorId.equals(other$auditorId)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $auditorId = this.getAuditorId();
        result = result * PRIME + ($auditorId == null ? 43 : $auditorId.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RemoveSpaceAuditorRequest(auditorId=" + this.getAuditorId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    /**
     * The auditor id
     *
     * @return the auditor id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuditorId() {
        return this.auditorId;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}