// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Disassociate Developer with the Space by Username operation
 */
public final class RemoveSpaceDeveloperByUsernameRequest implements Validatable {
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * The username
     *
     * @param username the username
     */
    private final String username;

    RemoveSpaceDeveloperByUsernameRequest(String spaceId, String username) {
        this.spaceId = spaceId;
        this.username = username;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        if (this.username == null) {
            builder.message("username must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RemoveSpaceDeveloperByUsernameRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String username;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RemoveSpaceDeveloperByUsernameRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceDeveloperByUsernameRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceDeveloperByUsernameRequestBuilder username(final String username) {
            this.username = username;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceDeveloperByUsernameRequest build() {
            return new RemoveSpaceDeveloperByUsernameRequest(spaceId, username);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RemoveSpaceDeveloperByUsernameRequest.RemoveSpaceDeveloperByUsernameRequestBuilder(spaceId=" + this.spaceId + ", username=" + this.username + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RemoveSpaceDeveloperByUsernameRequestBuilder builder() {
        return new RemoveSpaceDeveloperByUsernameRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RemoveSpaceDeveloperByUsernameRequest)) return false;
        final RemoveSpaceDeveloperByUsernameRequest other = (RemoveSpaceDeveloperByUsernameRequest)o;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        final java.lang.Object this$username = this.getUsername();
        final java.lang.Object other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        final java.lang.Object $username = this.getUsername();
        result = result * PRIME + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RemoveSpaceDeveloperByUsernameRequest(spaceId=" + this.getSpaceId() + ", username=" + this.getUsername() + ")";
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The username
     *
     * @return the username
     */
    @JsonProperty("username")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUsername() {
        return this.username;
    }
}