// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Remove Security Group from the Space operation
 */
public final class RemoveSpaceSecurityGroupRequest implements Validatable {
    
    /**
     * The security group id
     *
     * @param securityGroupId the security group id
     */
    private final String securityGroupId;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    RemoveSpaceSecurityGroupRequest(String securityGroupId, String spaceId) {
        this.securityGroupId = securityGroupId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.securityGroupId == null) {
            builder.message("security group id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RemoveSpaceSecurityGroupRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String securityGroupId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RemoveSpaceSecurityGroupRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceSecurityGroupRequestBuilder securityGroupId(final String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceSecurityGroupRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveSpaceSecurityGroupRequest build() {
            return new RemoveSpaceSecurityGroupRequest(securityGroupId, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RemoveSpaceSecurityGroupRequest.RemoveSpaceSecurityGroupRequestBuilder(securityGroupId=" + this.securityGroupId + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RemoveSpaceSecurityGroupRequestBuilder builder() {
        return new RemoveSpaceSecurityGroupRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RemoveSpaceSecurityGroupRequest)) return false;
        final RemoveSpaceSecurityGroupRequest other = (RemoveSpaceSecurityGroupRequest)o;
        final java.lang.Object this$securityGroupId = this.getSecurityGroupId();
        final java.lang.Object other$securityGroupId = other.getSecurityGroupId();
        if (this$securityGroupId == null ? other$securityGroupId != null : !this$securityGroupId.equals(other$securityGroupId)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $securityGroupId = this.getSecurityGroupId();
        result = result * PRIME + ($securityGroupId == null ? 43 : $securityGroupId.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RemoveSpaceSecurityGroupRequest(securityGroupId=" + this.getSecurityGroupId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    /**
     * The security group id
     *
     * @return the security group id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}