// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.List;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the Update a Space operation
 */
public final class UpdateSpaceRequest implements Validatable {
    
    /**
     * The allow ssh
     *
     * @param allowSsh the allow ssh
     */
    private final Boolean allowSsh;
    
    /**
     * The auditor ids
     *
     * @param auditorIds the auditor ids
     */
    private final List<String> auditorIds;
    
    /**
     * The developer ids
     *
     * @param developerIds the developer ids
     */
    private final List<String> developerIds;
    
    /**
     * The domain ids
     *
     * @param domainIds the domain ids
     */
    private final List<String> domainIds;
    
    /**
     * The manager ids
     *
     * @param managerIds the manager ids
     */
    private final List<String> managerIds;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;
    
    /**
     * The security group ids
     *
     * @param securityGroupIds the security group ids
     */
    private final List<String> securityGroupIds;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    UpdateSpaceRequest(Boolean allowSsh, List<String> auditorIds, List<String> developerIds, List<String> domainIds, List<String> managerIds, String name, String organizationId, List<String> securityGroupIds, String spaceId) {
        this.allowSsh = allowSsh;
        this.auditorIds = auditorIds;
        this.developerIds = developerIds;
        this.domainIds = domainIds;
        this.managerIds = managerIds;
        this.name = name;
        this.organizationId = organizationId;
        this.securityGroupIds = securityGroupIds;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateSpaceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean allowSsh;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> auditorIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> developerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> domainIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> managerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> securityGroupIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateSpaceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder allowSsh(final Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder auditorId(final String auditorId) {
            if (this.auditorIds == null) this.auditorIds = new java.util.ArrayList<String>();
            this.auditorIds.add(auditorId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder auditorIds(final java.util.Collection<? extends String> auditorIds) {
            if (this.auditorIds == null) this.auditorIds = new java.util.ArrayList<String>();
            this.auditorIds.addAll(auditorIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder developerId(final String developerId) {
            if (this.developerIds == null) this.developerIds = new java.util.ArrayList<String>();
            this.developerIds.add(developerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder developerIds(final java.util.Collection<? extends String> developerIds) {
            if (this.developerIds == null) this.developerIds = new java.util.ArrayList<String>();
            this.developerIds.addAll(developerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder domainId(final String domainId) {
            if (this.domainIds == null) this.domainIds = new java.util.ArrayList<String>();
            this.domainIds.add(domainId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder domainIds(final java.util.Collection<? extends String> domainIds) {
            if (this.domainIds == null) this.domainIds = new java.util.ArrayList<String>();
            this.domainIds.addAll(domainIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder managerId(final String managerId) {
            if (this.managerIds == null) this.managerIds = new java.util.ArrayList<String>();
            this.managerIds.add(managerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder managerIds(final java.util.Collection<? extends String> managerIds) {
            if (this.managerIds == null) this.managerIds = new java.util.ArrayList<String>();
            this.managerIds.addAll(managerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder securityGroupId(final String securityGroupId) {
            if (this.securityGroupIds == null) this.securityGroupIds = new java.util.ArrayList<String>();
            this.securityGroupIds.add(securityGroupId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder securityGroupIds(final java.util.Collection<? extends String> securityGroupIds) {
            if (this.securityGroupIds == null) this.securityGroupIds = new java.util.ArrayList<String>();
            this.securityGroupIds.addAll(securityGroupIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateSpaceRequest build() {
            java.util.List<String> auditorIds;
            switch (this.auditorIds == null ? 0 : this.auditorIds.size()) {
            case 0: 
                auditorIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                auditorIds = java.util.Collections.singletonList(this.auditorIds.get(0));
                break;
            
            default: 
                auditorIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.auditorIds));
            
            }
            java.util.List<String> developerIds;
            switch (this.developerIds == null ? 0 : this.developerIds.size()) {
            case 0: 
                developerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                developerIds = java.util.Collections.singletonList(this.developerIds.get(0));
                break;
            
            default: 
                developerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.developerIds));
            
            }
            java.util.List<String> domainIds;
            switch (this.domainIds == null ? 0 : this.domainIds.size()) {
            case 0: 
                domainIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                domainIds = java.util.Collections.singletonList(this.domainIds.get(0));
                break;
            
            default: 
                domainIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.domainIds));
            
            }
            java.util.List<String> managerIds;
            switch (this.managerIds == null ? 0 : this.managerIds.size()) {
            case 0: 
                managerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                managerIds = java.util.Collections.singletonList(this.managerIds.get(0));
                break;
            
            default: 
                managerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.managerIds));
            
            }
            java.util.List<String> securityGroupIds;
            switch (this.securityGroupIds == null ? 0 : this.securityGroupIds.size()) {
            case 0: 
                securityGroupIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                securityGroupIds = java.util.Collections.singletonList(this.securityGroupIds.get(0));
                break;
            
            default: 
                securityGroupIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.securityGroupIds));
            
            }
            return new UpdateSpaceRequest(allowSsh, auditorIds, developerIds, domainIds, managerIds, name, organizationId, securityGroupIds, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateSpaceRequest.UpdateSpaceRequestBuilder(allowSsh=" + this.allowSsh + ", auditorIds=" + this.auditorIds + ", developerIds=" + this.developerIds + ", domainIds=" + this.domainIds + ", managerIds=" + this.managerIds + ", name=" + this.name + ", organizationId=" + this.organizationId + ", securityGroupIds=" + this.securityGroupIds + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateSpaceRequestBuilder builder() {
        return new UpdateSpaceRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UpdateSpaceRequest)) return false;
        final UpdateSpaceRequest other = (UpdateSpaceRequest)o;
        final java.lang.Object this$allowSsh = this.getAllowSsh();
        final java.lang.Object other$allowSsh = other.getAllowSsh();
        if (this$allowSsh == null ? other$allowSsh != null : !this$allowSsh.equals(other$allowSsh)) return false;
        final java.lang.Object this$auditorIds = this.getAuditorIds();
        final java.lang.Object other$auditorIds = other.getAuditorIds();
        if (this$auditorIds == null ? other$auditorIds != null : !this$auditorIds.equals(other$auditorIds)) return false;
        final java.lang.Object this$developerIds = this.getDeveloperIds();
        final java.lang.Object other$developerIds = other.getDeveloperIds();
        if (this$developerIds == null ? other$developerIds != null : !this$developerIds.equals(other$developerIds)) return false;
        final java.lang.Object this$domainIds = this.getDomainIds();
        final java.lang.Object other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !this$domainIds.equals(other$domainIds)) return false;
        final java.lang.Object this$managerIds = this.getManagerIds();
        final java.lang.Object other$managerIds = other.getManagerIds();
        if (this$managerIds == null ? other$managerIds != null : !this$managerIds.equals(other$managerIds)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        final java.lang.Object this$securityGroupIds = this.getSecurityGroupIds();
        final java.lang.Object other$securityGroupIds = other.getSecurityGroupIds();
        if (this$securityGroupIds == null ? other$securityGroupIds != null : !this$securityGroupIds.equals(other$securityGroupIds)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $allowSsh = this.getAllowSsh();
        result = result * PRIME + ($allowSsh == null ? 43 : $allowSsh.hashCode());
        final java.lang.Object $auditorIds = this.getAuditorIds();
        result = result * PRIME + ($auditorIds == null ? 43 : $auditorIds.hashCode());
        final java.lang.Object $developerIds = this.getDeveloperIds();
        result = result * PRIME + ($developerIds == null ? 43 : $developerIds.hashCode());
        final java.lang.Object $domainIds = this.getDomainIds();
        result = result * PRIME + ($domainIds == null ? 43 : $domainIds.hashCode());
        final java.lang.Object $managerIds = this.getManagerIds();
        result = result * PRIME + ($managerIds == null ? 43 : $managerIds.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        final java.lang.Object $securityGroupIds = this.getSecurityGroupIds();
        result = result * PRIME + ($securityGroupIds == null ? 43 : $securityGroupIds.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "UpdateSpaceRequest(allowSsh=" + this.getAllowSsh() + ", auditorIds=" + this.getAuditorIds() + ", developerIds=" + this.getDeveloperIds() + ", domainIds=" + this.getDomainIds() + ", managerIds=" + this.getManagerIds() + ", name=" + this.getName() + ", organizationId=" + this.getOrganizationId() + ", securityGroupIds=" + this.getSecurityGroupIds() + ", spaceId=" + this.getSpaceId() + ")";
    }

    /**
     * The allow ssh
     *
     * @return the allow ssh
     */
    @JsonProperty("allow_ssh")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getAllowSsh() {
        return this.allowSsh;
    }

    /**
     * The auditor ids
     *
     * @return the auditor ids
     */
    @JsonProperty("auditor_guids")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getAuditorIds() {
        return this.auditorIds;
    }

    /**
     * The developer ids
     *
     * @return the developer ids
     */
    @JsonProperty("developer_guids")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    /**
     * The domain ids
     *
     * @return the domain ids
     */
    @JsonProperty("domain_guids")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    /**
     * The manager ids
     *
     * @return the manager ids
     */
    @JsonProperty("manager_guids")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getManagerIds() {
        return this.managerIds;
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonProperty("organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * The security group ids
     *
     * @return the security group ids
     */
    @JsonProperty("security_group_guids")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}