// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.Map;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the Create User Provided Service Instance
 */
public final class CreateUserProvidedServiceInstanceRequest implements Validatable {
    
    /**
     * Key/value pairs that can be stored to store credentials
     */
    private final Map<String, Object> credentials;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * URL to which requests for bound routes will be forwarded
     *
     * @param routeServiceUrl the route service url
     */
    private final String routeServiceUrl;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * The url for the syslog_drain to direct to
     *
     * @param syslogDrainUrl the syslog drain url
     */
    private final String syslogDrainUrl;

    CreateUserProvidedServiceInstanceRequest(Map<String, Object> credentials, String name, String routeServiceUrl, String spaceId, String syslogDrainUrl) {
        this.credentials = credentials;
        this.name = name;
        this.routeServiceUrl = routeServiceUrl;
        this.spaceId = spaceId;
        this.syslogDrainUrl = syslogDrainUrl;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateUserProvidedServiceInstanceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> credentials$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> credentials$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routeServiceUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String syslogDrainUrl;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateUserProvidedServiceInstanceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateUserProvidedServiceInstanceRequestBuilder credential(final String credentialKey, final Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateUserProvidedServiceInstanceRequestBuilder credentials(final java.util.Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateUserProvidedServiceInstanceRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateUserProvidedServiceInstanceRequestBuilder routeServiceUrl(final String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateUserProvidedServiceInstanceRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateUserProvidedServiceInstanceRequestBuilder syslogDrainUrl(final String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateUserProvidedServiceInstanceRequest build() {
            java.util.Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
            case 0: 
                credentials = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                credentials = java.util.Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                break;
            
            default: 
                credentials = new java.util.LinkedHashMap<String, Object>(this.credentials$key.size() < 1073741824 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.credentials$key.size(); $i++) credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                credentials = java.util.Collections.unmodifiableMap(credentials);
            
            }
            return new CreateUserProvidedServiceInstanceRequest(credentials, name, routeServiceUrl, spaceId, syslogDrainUrl);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateUserProvidedServiceInstanceRequest.CreateUserProvidedServiceInstanceRequestBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", name=" + this.name + ", routeServiceUrl=" + this.routeServiceUrl + ", spaceId=" + this.spaceId + ", syslogDrainUrl=" + this.syslogDrainUrl + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateUserProvidedServiceInstanceRequestBuilder builder() {
        return new CreateUserProvidedServiceInstanceRequestBuilder();
    }

    /**
     * Key/value pairs that can be stored to store credentials
     *
     * @return the credentials
     */
    @JsonProperty("credentials")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * URL to which requests for bound routes will be forwarded
     *
     * @return the route service url
     */
    @JsonProperty("route_service_url")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonProperty("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The url for the syslog_drain to direct to
     *
     * @return the syslog drain url
     */
    @JsonProperty("syslog_drain_url")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }
}