// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Get User Provided Service Instance operation
 */
public final class GetUserProvidedServiceInstanceRequest implements Validatable {
    
    /**
     * The user provided service instance id
     *
     * @param userProvidedServiceInstanceId the user provided service instance id
     */
    private final String userProvidedServiceInstanceId;

    GetUserProvidedServiceInstanceRequest(String userProvidedServiceInstanceId) {
        this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.userProvidedServiceInstanceId == null) {
            builder.message("user provided service instance id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetUserProvidedServiceInstanceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String userProvidedServiceInstanceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetUserProvidedServiceInstanceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetUserProvidedServiceInstanceRequestBuilder userProvidedServiceInstanceId(final String userProvidedServiceInstanceId) {
            this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetUserProvidedServiceInstanceRequest build() {
            return new GetUserProvidedServiceInstanceRequest(userProvidedServiceInstanceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetUserProvidedServiceInstanceRequest.GetUserProvidedServiceInstanceRequestBuilder(userProvidedServiceInstanceId=" + this.userProvidedServiceInstanceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetUserProvidedServiceInstanceRequestBuilder builder() {
        return new GetUserProvidedServiceInstanceRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetUserProvidedServiceInstanceRequest)) return false;
        final GetUserProvidedServiceInstanceRequest other = (GetUserProvidedServiceInstanceRequest)o;
        final java.lang.Object this$userProvidedServiceInstanceId = this.getUserProvidedServiceInstanceId();
        final java.lang.Object other$userProvidedServiceInstanceId = other.getUserProvidedServiceInstanceId();
        if (this$userProvidedServiceInstanceId == null ? other$userProvidedServiceInstanceId != null : !this$userProvidedServiceInstanceId.equals(other$userProvidedServiceInstanceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $userProvidedServiceInstanceId = this.getUserProvidedServiceInstanceId();
        result = result * PRIME + ($userProvidedServiceInstanceId == null ? 43 : $userProvidedServiceInstanceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetUserProvidedServiceInstanceRequest(userProvidedServiceInstanceId=" + this.getUserProvidedServiceInstanceId() + ")";
    }

    /**
     * The user provided service instance id
     *
     * @return the user provided service instance id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUserProvidedServiceInstanceId() {
        return this.userProvidedServiceInstanceId;
    }
}