// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service Bindings for the User Provided Service Instance operation
 */
public final class ListUserProvidedServiceInstanceServiceBindingsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The ids of the applications
     *
     * @param applicationIds the ids of the applications to filter on
     */
    private final List<String> applicationIds;
    
    /**
     * The user provided service instance id
     *
     * @param userProvidedServiceInstanceId the user provided service instance id
     */
    private final String userProvidedServiceInstanceId;

    ListUserProvidedServiceInstanceServiceBindingsRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, String userProvidedServiceInstanceId) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.userProvidedServiceInstanceId == null) {
            builder.message("user provided service instance id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListUserProvidedServiceInstanceServiceBindingsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> applicationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String userProvidedServiceInstanceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListUserProvidedServiceInstanceServiceBindingsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder applicationId(final String applicationId) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.add(applicationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder applicationIds(final java.util.Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder userProvidedServiceInstanceId(final String userProvidedServiceInstanceId) {
            this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUserProvidedServiceInstanceServiceBindingsRequest build() {
            java.util.List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
            case 0: 
                applicationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                applicationIds = java.util.Collections.singletonList(this.applicationIds.get(0));
                break;
            
            default: 
                applicationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.applicationIds));
            
            }
            return new ListUserProvidedServiceInstanceServiceBindingsRequest(orderDirection, page, resultsPerPage, applicationIds, userProvidedServiceInstanceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListUserProvidedServiceInstanceServiceBindingsRequest.ListUserProvidedServiceInstanceServiceBindingsRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", userProvidedServiceInstanceId=" + this.userProvidedServiceInstanceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListUserProvidedServiceInstanceServiceBindingsRequestBuilder builder() {
        return new ListUserProvidedServiceInstanceServiceBindingsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListUserProvidedServiceInstanceServiceBindingsRequest)) return false;
        final ListUserProvidedServiceInstanceServiceBindingsRequest other = (ListUserProvidedServiceInstanceServiceBindingsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationIds = this.getApplicationIds();
        final java.lang.Object other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !this$applicationIds.equals(other$applicationIds)) return false;
        final java.lang.Object this$userProvidedServiceInstanceId = this.getUserProvidedServiceInstanceId();
        final java.lang.Object other$userProvidedServiceInstanceId = other.getUserProvidedServiceInstanceId();
        if (this$userProvidedServiceInstanceId == null ? other$userProvidedServiceInstanceId != null : !this$userProvidedServiceInstanceId.equals(other$userProvidedServiceInstanceId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListUserProvidedServiceInstanceServiceBindingsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationIds = this.getApplicationIds();
        result = result * PRIME + ($applicationIds == null ? 43 : $applicationIds.hashCode());
        final java.lang.Object $userProvidedServiceInstanceId = this.getUserProvidedServiceInstanceId();
        result = result * PRIME + ($userProvidedServiceInstanceId == null ? 43 : $userProvidedServiceInstanceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListUserProvidedServiceInstanceServiceBindingsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", userProvidedServiceInstanceId=" + this.getUserProvidedServiceInstanceId() + ")";
    }

    /**
     * The ids of the applications
     *
     * @return the ids of the applications to filter on
     */
    @InFilterParameter("app_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    /**
     * The user provided service instance id
     *
     * @return the user provided  service instance id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUserProvidedServiceInstanceId() {
        return this.userProvidedServiceInstanceId;
    }
}