// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.Map;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the Update User Provided Service Instance
 */
public final class UpdateUserProvidedServiceInstanceRequest implements Validatable {
    
    /**
     * Key/value pairs that can be stored to store credentials
     */
    private final Map<String, Object> credentials;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * URL to which requests for bound routes will be forwarded
     *
     * @param routeServiceUrl the route service url
     */
    private final String routeServiceUrl;
    
    /**
     * The url for the syslog_drain to direct to
     *
     * @param syslogDrainUrl the syslog drain url
     */
    private final String syslogDrainUrl;
    
    /**
     * The user provided service instance id
     *
     * @param userProvidedServiceInstanceId the user provided service instance id
     */
    private final String userProvidedServiceInstanceId;

    UpdateUserProvidedServiceInstanceRequest(Map<String, Object> credentials, String name, String routeServiceUrl, String syslogDrainUrl, String userProvidedServiceInstanceId) {
        this.credentials = credentials;
        this.name = name;
        this.routeServiceUrl = routeServiceUrl;
        this.syslogDrainUrl = syslogDrainUrl;
        this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.userProvidedServiceInstanceId == null) {
            builder.message("user provided service instance id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateUserProvidedServiceInstanceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> credentials$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> credentials$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routeServiceUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String syslogDrainUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String userProvidedServiceInstanceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateUserProvidedServiceInstanceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateUserProvidedServiceInstanceRequestBuilder credential(final String credentialKey, final Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateUserProvidedServiceInstanceRequestBuilder credentials(final java.util.Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateUserProvidedServiceInstanceRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateUserProvidedServiceInstanceRequestBuilder routeServiceUrl(final String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateUserProvidedServiceInstanceRequestBuilder syslogDrainUrl(final String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateUserProvidedServiceInstanceRequestBuilder userProvidedServiceInstanceId(final String userProvidedServiceInstanceId) {
            this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateUserProvidedServiceInstanceRequest build() {
            java.util.Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
            case 0: 
                credentials = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                credentials = java.util.Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                break;
            
            default: 
                credentials = new java.util.LinkedHashMap<String, Object>(this.credentials$key.size() < 1073741824 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.credentials$key.size(); $i++) credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                credentials = java.util.Collections.unmodifiableMap(credentials);
            
            }
            return new UpdateUserProvidedServiceInstanceRequest(credentials, name, routeServiceUrl, syslogDrainUrl, userProvidedServiceInstanceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateUserProvidedServiceInstanceRequest.UpdateUserProvidedServiceInstanceRequestBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", name=" + this.name + ", routeServiceUrl=" + this.routeServiceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + ", userProvidedServiceInstanceId=" + this.userProvidedServiceInstanceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateUserProvidedServiceInstanceRequestBuilder builder() {
        return new UpdateUserProvidedServiceInstanceRequestBuilder();
    }

    /**
     * Key/value pairs that can be stored to store credentials
     *
     * @return the credentials
     */
    @JsonProperty("credentials")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * URL to which requests for bound routes will be forwarded
     *
     * @return the route service url
     */
    @JsonProperty("route_service_url")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    /**
     * The url for the syslog_drain to direct to
     *
     * @return the syslog drain url
     */
    @JsonProperty("syslog_drain_url")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    /**
     * The user provided service instance id
     *
     * @return the user provided service instance id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUserProvidedServiceInstanceId() {
        return this.userProvidedServiceInstanceId;
    }
}