// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * The entity response payload for User Provided Service Instances
 */
public final class UserProvidedServiceInstanceEntity {
    
    /**
     * The credentials
     *
     * @param credentials the credentials
     */
    private final Map<String, Object> credentials;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * URL to which requests for bound routes will be forwarded
     *
     * @param routeServiceUrl the route service url
     */
    private final String routeServiceUrl;
    
    /**
     * The routes url
     *
     * @param routesUrl the routes url
     */
    private final String routesUrl;
    
    /**
     * The service bindings url
     *
     * @param serviceBindingsUrl the service bindings url
     */
    private final String serviceBindingsUrl;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * The space url
     *
     * @param spaceUrl the space url
     */
    private final String spaceUrl;
    
    /**
     * The url for the syslog_drain to direct to
     *
     * @param syslogDrainUrl the syslog drain url
     */
    private final String syslogDrainUrl;
    
    /**
     * The type
     *
     * @param type the type
     */
    private final String type;

    UserProvidedServiceInstanceEntity(@JsonProperty("credentials") Map<String, Object> credentials, @JsonProperty("name") String name, @JsonProperty("route_service_url") String routeServiceUrl, @JsonProperty("routes_url") String routesUrl, @JsonProperty("service_bindings_url") String serviceBindingsUrl, @JsonProperty("space_guid") String spaceId, @JsonProperty("space_url") String spaceUrl, @JsonProperty("syslog_drain_url") String syslogDrainUrl, @JsonProperty("type") String type) {
        this.credentials = credentials;
        this.name = name;
        this.routeServiceUrl = routeServiceUrl;
        this.routesUrl = routesUrl;
        this.serviceBindingsUrl = serviceBindingsUrl;
        this.spaceId = spaceId;
        this.spaceUrl = spaceUrl;
        this.syslogDrainUrl = syslogDrainUrl;
        this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UserProvidedServiceInstanceEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> credentials$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> credentials$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routeServiceUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routesUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceBindingsUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String syslogDrainUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String type;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UserProvidedServiceInstanceEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder credential(final String credentialKey, final Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder credentials(final java.util.Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new java.util.ArrayList<String>();
                this.credentials$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder routeServiceUrl(final String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder routesUrl(final String routesUrl) {
            this.routesUrl = routesUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder serviceBindingsUrl(final String serviceBindingsUrl) {
            this.serviceBindingsUrl = serviceBindingsUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder spaceUrl(final String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder syslogDrainUrl(final String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntityBuilder type(final String type) {
            this.type = type;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UserProvidedServiceInstanceEntity build() {
            java.util.Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
            case 0: 
                credentials = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                credentials = java.util.Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                break;
            
            default: 
                credentials = new java.util.LinkedHashMap<String, Object>(this.credentials$key.size() < 1073741824 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.credentials$key.size(); $i++) credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                credentials = java.util.Collections.unmodifiableMap(credentials);
            
            }
            return new UserProvidedServiceInstanceEntity(credentials, name, routeServiceUrl, routesUrl, serviceBindingsUrl, spaceId, spaceUrl, syslogDrainUrl, type);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UserProvidedServiceInstanceEntity.UserProvidedServiceInstanceEntityBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", name=" + this.name + ", routeServiceUrl=" + this.routeServiceUrl + ", routesUrl=" + this.routesUrl + ", serviceBindingsUrl=" + this.serviceBindingsUrl + ", spaceId=" + this.spaceId + ", spaceUrl=" + this.spaceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + ", type=" + this.type + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UserProvidedServiceInstanceEntityBuilder builder() {
        return new UserProvidedServiceInstanceEntityBuilder();
    }

    /**
     * The credentials
     *
     * @return the credentials
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * URL to which requests for bound routes will be forwarded
     *
     * @return the route service url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    /**
     * The routes url
     *
     * @return the routes url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRoutesUrl() {
        return this.routesUrl;
    }

    /**
     * The service bindings url
     *
     * @return the service bindings url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceBindingsUrl() {
        return this.serviceBindingsUrl;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The space url
     *
     * @return the space url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    /**
     * The url for the syslog_drain to direct to
     *
     * @return the syslog drain url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    /**
     * The type
     *
     * @return the type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getType() {
        return this.type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UserProvidedServiceInstanceEntity)) return false;
        final UserProvidedServiceInstanceEntity other = (UserProvidedServiceInstanceEntity)o;
        final java.lang.Object this$credentials = this.getCredentials();
        final java.lang.Object other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$routeServiceUrl = this.getRouteServiceUrl();
        final java.lang.Object other$routeServiceUrl = other.getRouteServiceUrl();
        if (this$routeServiceUrl == null ? other$routeServiceUrl != null : !this$routeServiceUrl.equals(other$routeServiceUrl)) return false;
        final java.lang.Object this$routesUrl = this.getRoutesUrl();
        final java.lang.Object other$routesUrl = other.getRoutesUrl();
        if (this$routesUrl == null ? other$routesUrl != null : !this$routesUrl.equals(other$routesUrl)) return false;
        final java.lang.Object this$serviceBindingsUrl = this.getServiceBindingsUrl();
        final java.lang.Object other$serviceBindingsUrl = other.getServiceBindingsUrl();
        if (this$serviceBindingsUrl == null ? other$serviceBindingsUrl != null : !this$serviceBindingsUrl.equals(other$serviceBindingsUrl)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        final java.lang.Object this$spaceUrl = this.getSpaceUrl();
        final java.lang.Object other$spaceUrl = other.getSpaceUrl();
        if (this$spaceUrl == null ? other$spaceUrl != null : !this$spaceUrl.equals(other$spaceUrl)) return false;
        final java.lang.Object this$syslogDrainUrl = this.getSyslogDrainUrl();
        final java.lang.Object other$syslogDrainUrl = other.getSyslogDrainUrl();
        if (this$syslogDrainUrl == null ? other$syslogDrainUrl != null : !this$syslogDrainUrl.equals(other$syslogDrainUrl)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $credentials = this.getCredentials();
        result = result * PRIME + ($credentials == null ? 43 : $credentials.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $routeServiceUrl = this.getRouteServiceUrl();
        result = result * PRIME + ($routeServiceUrl == null ? 43 : $routeServiceUrl.hashCode());
        final java.lang.Object $routesUrl = this.getRoutesUrl();
        result = result * PRIME + ($routesUrl == null ? 43 : $routesUrl.hashCode());
        final java.lang.Object $serviceBindingsUrl = this.getServiceBindingsUrl();
        result = result * PRIME + ($serviceBindingsUrl == null ? 43 : $serviceBindingsUrl.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        final java.lang.Object $spaceUrl = this.getSpaceUrl();
        result = result * PRIME + ($spaceUrl == null ? 43 : $spaceUrl.hashCode());
        final java.lang.Object $syslogDrainUrl = this.getSyslogDrainUrl();
        result = result * PRIME + ($syslogDrainUrl == null ? 43 : $syslogDrainUrl.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "UserProvidedServiceInstanceEntity(credentials=" + this.getCredentials() + ", name=" + this.getName() + ", routeServiceUrl=" + this.getRouteServiceUrl() + ", routesUrl=" + this.getRoutesUrl() + ", serviceBindingsUrl=" + this.getServiceBindingsUrl() + ", spaceId=" + this.getSpaceId() + ", spaceUrl=" + this.getSpaceUrl() + ", syslogDrainUrl=" + this.getSyslogDrainUrl() + ", type=" + this.getType() + ")";
    }
}