// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.users;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Users operation
 */
public final class ListUsersRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The audited organization ids
     *
     * @param auditedOrganizationIds the audited organization ids
     */
    private final List<String> auditedOrganizationIds;
    
    /**
     * The audited space ids
     *
     * @param auditedSpaceIds the audited space ids
     */
    private final List<String> auditedSpaceIds;
    
    /**
     * The billing managed organization ids
     *
     * @param billingManagedOrganizationIds the billing managed organization ids
     */
    private final List<String> billingManagedOrganizationIds;
    
    /**
     * The managed organization ids
     *
     * @param managedOrganizationIds the managed organization ids
     */
    private final List<String> managedOrganizationIds;
    
    /**
     * The managed space ids
     *
     * @param managedSpaceIds the managed space ids
     */
    private final List<String> managedSpaceIds;
    
    /**
     * The organization ids
     *
     * @param organizationIds the organization ids
     */
    private final List<String> organizationIds;
    
    /**
     * The space ids
     *
     * @param spaceIds the space ids
     */
    private final List<String> spaceIds;

    ListUsersRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> auditedOrganizationIds, List<String> auditedSpaceIds, List<String> billingManagedOrganizationIds, List<String> managedOrganizationIds, List<String> managedSpaceIds, List<String> organizationIds, List<String> spaceIds) {
        super(orderDirection, page, resultsPerPage);
        this.auditedOrganizationIds = auditedOrganizationIds;
        this.auditedSpaceIds = auditedSpaceIds;
        this.billingManagedOrganizationIds = billingManagedOrganizationIds;
        this.managedOrganizationIds = managedOrganizationIds;
        this.managedSpaceIds = managedSpaceIds;
        this.organizationIds = organizationIds;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListUsersRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> auditedOrganizationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> auditedSpaceIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> billingManagedOrganizationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> managedOrganizationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> managedSpaceIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> organizationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> spaceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListUsersRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder auditedOrganizationId(final String auditedOrganizationId) {
            if (this.auditedOrganizationIds == null) this.auditedOrganizationIds = new java.util.ArrayList<String>();
            this.auditedOrganizationIds.add(auditedOrganizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder auditedOrganizationIds(final java.util.Collection<? extends String> auditedOrganizationIds) {
            if (this.auditedOrganizationIds == null) this.auditedOrganizationIds = new java.util.ArrayList<String>();
            this.auditedOrganizationIds.addAll(auditedOrganizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder auditedSpaceId(final String auditedSpaceId) {
            if (this.auditedSpaceIds == null) this.auditedSpaceIds = new java.util.ArrayList<String>();
            this.auditedSpaceIds.add(auditedSpaceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder auditedSpaceIds(final java.util.Collection<? extends String> auditedSpaceIds) {
            if (this.auditedSpaceIds == null) this.auditedSpaceIds = new java.util.ArrayList<String>();
            this.auditedSpaceIds.addAll(auditedSpaceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder billingManagedOrganizationId(final String billingManagedOrganizationId) {
            if (this.billingManagedOrganizationIds == null) this.billingManagedOrganizationIds = new java.util.ArrayList<String>();
            this.billingManagedOrganizationIds.add(billingManagedOrganizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder billingManagedOrganizationIds(final java.util.Collection<? extends String> billingManagedOrganizationIds) {
            if (this.billingManagedOrganizationIds == null) this.billingManagedOrganizationIds = new java.util.ArrayList<String>();
            this.billingManagedOrganizationIds.addAll(billingManagedOrganizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder managedOrganizationId(final String managedOrganizationId) {
            if (this.managedOrganizationIds == null) this.managedOrganizationIds = new java.util.ArrayList<String>();
            this.managedOrganizationIds.add(managedOrganizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder managedOrganizationIds(final java.util.Collection<? extends String> managedOrganizationIds) {
            if (this.managedOrganizationIds == null) this.managedOrganizationIds = new java.util.ArrayList<String>();
            this.managedOrganizationIds.addAll(managedOrganizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder managedSpaceId(final String managedSpaceId) {
            if (this.managedSpaceIds == null) this.managedSpaceIds = new java.util.ArrayList<String>();
            this.managedSpaceIds.add(managedSpaceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder managedSpaceIds(final java.util.Collection<? extends String> managedSpaceIds) {
            if (this.managedSpaceIds == null) this.managedSpaceIds = new java.util.ArrayList<String>();
            this.managedSpaceIds.addAll(managedSpaceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder organizationId(final String organizationId) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.add(organizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder organizationIds(final java.util.Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder spaceId(final String spaceId) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.add(spaceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequestBuilder spaceIds(final java.util.Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListUsersRequest build() {
            java.util.List<String> auditedOrganizationIds;
            switch (this.auditedOrganizationIds == null ? 0 : this.auditedOrganizationIds.size()) {
            case 0: 
                auditedOrganizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                auditedOrganizationIds = java.util.Collections.singletonList(this.auditedOrganizationIds.get(0));
                break;
            
            default: 
                auditedOrganizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.auditedOrganizationIds));
            
            }
            java.util.List<String> auditedSpaceIds;
            switch (this.auditedSpaceIds == null ? 0 : this.auditedSpaceIds.size()) {
            case 0: 
                auditedSpaceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                auditedSpaceIds = java.util.Collections.singletonList(this.auditedSpaceIds.get(0));
                break;
            
            default: 
                auditedSpaceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.auditedSpaceIds));
            
            }
            java.util.List<String> billingManagedOrganizationIds;
            switch (this.billingManagedOrganizationIds == null ? 0 : this.billingManagedOrganizationIds.size()) {
            case 0: 
                billingManagedOrganizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                billingManagedOrganizationIds = java.util.Collections.singletonList(this.billingManagedOrganizationIds.get(0));
                break;
            
            default: 
                billingManagedOrganizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.billingManagedOrganizationIds));
            
            }
            java.util.List<String> managedOrganizationIds;
            switch (this.managedOrganizationIds == null ? 0 : this.managedOrganizationIds.size()) {
            case 0: 
                managedOrganizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                managedOrganizationIds = java.util.Collections.singletonList(this.managedOrganizationIds.get(0));
                break;
            
            default: 
                managedOrganizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.managedOrganizationIds));
            
            }
            java.util.List<String> managedSpaceIds;
            switch (this.managedSpaceIds == null ? 0 : this.managedSpaceIds.size()) {
            case 0: 
                managedSpaceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                managedSpaceIds = java.util.Collections.singletonList(this.managedSpaceIds.get(0));
                break;
            
            default: 
                managedSpaceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.managedSpaceIds));
            
            }
            java.util.List<String> organizationIds;
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
            case 0: 
                organizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                organizationIds = java.util.Collections.singletonList(this.organizationIds.get(0));
                break;
            
            default: 
                organizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.organizationIds));
            
            }
            java.util.List<String> spaceIds;
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
            case 0: 
                spaceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                spaceIds = java.util.Collections.singletonList(this.spaceIds.get(0));
                break;
            
            default: 
                spaceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.spaceIds));
            
            }
            return new ListUsersRequest(orderDirection, page, resultsPerPage, auditedOrganizationIds, auditedSpaceIds, billingManagedOrganizationIds, managedOrganizationIds, managedSpaceIds, organizationIds, spaceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListUsersRequest.ListUsersRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", auditedOrganizationIds=" + this.auditedOrganizationIds + ", auditedSpaceIds=" + this.auditedSpaceIds + ", billingManagedOrganizationIds=" + this.billingManagedOrganizationIds + ", managedOrganizationIds=" + this.managedOrganizationIds + ", managedSpaceIds=" + this.managedSpaceIds + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListUsersRequestBuilder builder() {
        return new ListUsersRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListUsersRequest)) return false;
        final ListUsersRequest other = (ListUsersRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$auditedOrganizationIds = this.getAuditedOrganizationIds();
        final java.lang.Object other$auditedOrganizationIds = other.getAuditedOrganizationIds();
        if (this$auditedOrganizationIds == null ? other$auditedOrganizationIds != null : !this$auditedOrganizationIds.equals(other$auditedOrganizationIds)) return false;
        final java.lang.Object this$auditedSpaceIds = this.getAuditedSpaceIds();
        final java.lang.Object other$auditedSpaceIds = other.getAuditedSpaceIds();
        if (this$auditedSpaceIds == null ? other$auditedSpaceIds != null : !this$auditedSpaceIds.equals(other$auditedSpaceIds)) return false;
        final java.lang.Object this$billingManagedOrganizationIds = this.getBillingManagedOrganizationIds();
        final java.lang.Object other$billingManagedOrganizationIds = other.getBillingManagedOrganizationIds();
        if (this$billingManagedOrganizationIds == null ? other$billingManagedOrganizationIds != null : !this$billingManagedOrganizationIds.equals(other$billingManagedOrganizationIds)) return false;
        final java.lang.Object this$managedOrganizationIds = this.getManagedOrganizationIds();
        final java.lang.Object other$managedOrganizationIds = other.getManagedOrganizationIds();
        if (this$managedOrganizationIds == null ? other$managedOrganizationIds != null : !this$managedOrganizationIds.equals(other$managedOrganizationIds)) return false;
        final java.lang.Object this$managedSpaceIds = this.getManagedSpaceIds();
        final java.lang.Object other$managedSpaceIds = other.getManagedSpaceIds();
        if (this$managedSpaceIds == null ? other$managedSpaceIds != null : !this$managedSpaceIds.equals(other$managedSpaceIds)) return false;
        final java.lang.Object this$organizationIds = this.getOrganizationIds();
        final java.lang.Object other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !this$organizationIds.equals(other$organizationIds)) return false;
        final java.lang.Object this$spaceIds = this.getSpaceIds();
        final java.lang.Object other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !this$spaceIds.equals(other$spaceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListUsersRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $auditedOrganizationIds = this.getAuditedOrganizationIds();
        result = result * PRIME + ($auditedOrganizationIds == null ? 43 : $auditedOrganizationIds.hashCode());
        final java.lang.Object $auditedSpaceIds = this.getAuditedSpaceIds();
        result = result * PRIME + ($auditedSpaceIds == null ? 43 : $auditedSpaceIds.hashCode());
        final java.lang.Object $billingManagedOrganizationIds = this.getBillingManagedOrganizationIds();
        result = result * PRIME + ($billingManagedOrganizationIds == null ? 43 : $billingManagedOrganizationIds.hashCode());
        final java.lang.Object $managedOrganizationIds = this.getManagedOrganizationIds();
        result = result * PRIME + ($managedOrganizationIds == null ? 43 : $managedOrganizationIds.hashCode());
        final java.lang.Object $managedSpaceIds = this.getManagedSpaceIds();
        result = result * PRIME + ($managedSpaceIds == null ? 43 : $managedSpaceIds.hashCode());
        final java.lang.Object $organizationIds = this.getOrganizationIds();
        result = result * PRIME + ($organizationIds == null ? 43 : $organizationIds.hashCode());
        final java.lang.Object $spaceIds = this.getSpaceIds();
        result = result * PRIME + ($spaceIds == null ? 43 : $spaceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListUsersRequest(super=" + super.toString() + ", auditedOrganizationIds=" + this.getAuditedOrganizationIds() + ", auditedSpaceIds=" + this.getAuditedSpaceIds() + ", billingManagedOrganizationIds=" + this.getBillingManagedOrganizationIds() + ", managedOrganizationIds=" + this.getManagedOrganizationIds() + ", managedSpaceIds=" + this.getManagedSpaceIds() + ", organizationIds=" + this.getOrganizationIds() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    /**
     * The audited organization ids
     *
     * @return the audited organization ids
     */
    @InFilterParameter("audited_organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getAuditedOrganizationIds() {
        return this.auditedOrganizationIds;
    }

    /**
     * The audited space ids
     *
     * @return the audited space ids
     */
    @InFilterParameter("audited_space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getAuditedSpaceIds() {
        return this.auditedSpaceIds;
    }

    /**
     * The billing managed organization ids
     *
     * @return the billing managed organization ids
     */
    @InFilterParameter("billing_managed_organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getBillingManagedOrganizationIds() {
        return this.billingManagedOrganizationIds;
    }

    /**
     * The managed organization ids
     *
     * @return the managed organization ids
     */
    @InFilterParameter("managed_organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getManagedOrganizationIds() {
        return this.managedOrganizationIds;
    }

    /**
     * The managed space ids
     *
     * @return the managed space ids
     */
    @InFilterParameter("managed_space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getManagedSpaceIds() {
        return this.managedSpaceIds;
    }

    /**
     * The organization ids
     *
     * @return the organization ids
     */
    @InFilterParameter("organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    /**
     * The space ids
     *
     * @return the space ids
     */
    @InFilterParameter("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }
}